/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class ASMDataUtil {
    private static Map<String, Class<?>> cache;

    public static String getModId(ASMDataTable.ASMData data) {
        return ((ModContainer)data.getCandidate().getContainedMods().get(0)).getModId();
    }

    public static <Anno extends Annotation> Anno getAnnotation(ASMDataTable.ASMData data, Class<Anno> clz) {
        return ASMDataUtil.getClass(data).getAnnotation(clz);
    }

    public static Field getField(ASMDataTable.ASMData data) {
        try {
            return ASMDataUtil.getClass(data).getField(data.getObjectName());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Optional<Object> getObject(ASMDataTable.ASMData data) {
        try {
            return Optional.fromNullable((Object)ASMDataUtil.getClass(data).getField(data.getObjectName()).get(null));
        }
        catch (NoSuchFieldException e) {
            return Optional.absent();
        }
        catch (IllegalAccessException e) {
            return Optional.absent();
        }
    }

    public static Class<?> getClass(ASMDataTable.ASMData data) {
        if (cache == null) {
            cache = Maps.newHashMap();
        }
        Class<?> c = null;
        try {
            String name = data.getClassName();
            if (cache.containsKey(name)) {
                c = cache.get(name);
            } else {
                c = Class.forName(name);
                cache.put(name, c);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return c;
    }

    public static void clear() {
        if (Loader.instance().getLoaderState() == LoaderState.AVAILABLE) {
            cache = null;
        }
    }
}

