/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.sound;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.infstudio.infinitylib.api.Instance;
import net.infstudio.infinitylib.api.LoadingDelegate;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.infstudio.infinitylib.api.utils.FileReference;
import net.infstudio.infinitylib.client.loading.ExternalResource;
import net.infstudio.infinitylib.client.loading.PackBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;

@SideOnly(value=Side.CLIENT)
@ModHandler
@LoadingDelegate
public class BGMPlayer
implements IResourceManagerReloadListener {
    @Instance
    private static BGMPlayer instance = new BGMPlayer();
    private ISound currentPlaying;
    private Map<String, Integer> loopTimeMap = new TreeMap<String, Integer>();
    private boolean isEnable;

    @SubscribeEvent
    public void onInit(FMLInitializationEvent event) {
        ExternalResource.register(new PackBase(FileReference.getDir(FileReference.mc, "bgm")){

            @Override
            public Set<String> domain() {
                return Sets.newHashSet((Object[])new String[]{"bgm1", "bgm2"});
            }
        });
    }

    private BGMPlayer() {
        this.enable(true);
    }

    public static BGMPlayer instance() {
        return instance;
    }

    public boolean isPlaying() {
        return this.currentPlaying != null;
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void enable(boolean isEnable) {
        this.isEnable = isEnable;
        if (isEnable) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    @SubscribeEvent
    public void playSound(PlaySoundEvent event) {
        if (event.category == SoundCategory.AMBIENT) {
            event.result = null;
        }
    }

    public void play(String name) {
        this.play((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation("bgm1", name)));
    }

    public void playLoop(String name) {
        this.play(new SoundLoop(name));
    }

    private void play(ISound sound) {
        if (this.isEnable) {
            if (this.currentPlaying != null) {
                Minecraft.func_71410_x().func_147118_V().func_147683_b(this.currentPlaying);
            }
            this.currentPlaying = sound;
            Minecraft.func_71410_x().func_147118_V().func_147682_a(this.currentPlaying);
        }
    }

    private void prepareContinueLoop(SoundLoop soundLoop) {
        SoundCategory category = SoundCategory.func_147154_a((String)soundLoop.nextChannel());
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        handler.func_147689_b();
        handler.func_147684_a(category, 0.0f);
        handler.func_147682_a((ISound)soundLoop.next());
    }

    public void stop() {
        if (this.isEnable) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(this.currentPlaying);
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.generateSoundJson(FileReference.getDir(FileReference.mc, "bgm"));
        this.loadLoopTime();
    }

    private void loadLoopTime() {
        File sounds = FileReference.getDir(FileReference.mc, "bgm", "sounds");
        File file = new File(sounds, "loop.properties");
        if (file.exists()) {
            try {
                List strings = FileUtils.readLines((File)file);
                for (String string : strings) {
                    String[] split = string.split("=");
                    if (split.length != 2) continue;
                    try {
                        this.loopTimeMap.put(split[0].replace(" ", ""), Integer.parseInt(split[1].replace(" ", "")));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateSoundJson(File assetsDir) {
        File soundsDir = FileReference.getDir(assetsDir, "sounds");
        ArrayList locations = Lists.newArrayList();
        this.discoverSoundsFile(soundsDir, locations);
        Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation[].class, (Object)new TypeAdapter<ResourceLocation[]>(){

            public void write(JsonWriter out, ResourceLocation[] value) throws IOException {
                out.beginObject();
                for (ResourceLocation loc : value) {
                    String path = loc.func_110623_a();
                    System.out.println(path.substring(path.lastIndexOf("/")));
                    out.name(path.substring(path.lastIndexOf("/"))).beginObject();
                    out.name("category").value(loc.func_110624_b());
                    out.name("sounds").beginArray();
                    out.beginObject();
                    out.name("name").value(path);
                    out.name("stream").value(true);
                    out.endObject();
                    out.endArray();
                    out.endObject();
                }
                out.endObject();
            }

            public ResourceLocation[] read(JsonReader in) throws IOException {
                return null;
            }
        }).setPrettyPrinting().create();
        String json = gson.toJson((Object)locations.toArray(), ResourceLocation[].class);
        if (json.isEmpty()) {
            return;
        }
        try {
            FileUtils.write((File)new File(assetsDir, "sounds.json"), (CharSequence)json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void discoverSoundsFile(File dir, final List<ResourceLocation> locations) {
        File[] musics = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    BGMPlayer.this.discoverSoundsFile(pathname, locations);
                    return false;
                }
                return pathname.getName().endsWith(".ogg");
            }
        });
        if (musics != null && musics.length != 0) {
            for (File music : musics) {
                String path = music.getPath();
                path = path.replace(".\\bgm\\sounds\\", "").replace(".ogg", "").replace("\\", "/");
                locations.add(new ResourceLocation("bgm1", path));
                locations.add(new ResourceLocation("bgm2", path));
            }
        }
    }

    class SoundLoop
    implements ISound {
        private ResourceLocation location;
        private SoundLoop nextSound;
        private long current;
        private long offset;

        SoundLoop(String name) {
            this("bgm1", name);
        }

        SoundLoop(String channel, String name) {
            this.location = new ResourceLocation(channel, name);
            this.nextSound = new SoundLoop(this.nextChannel(), this.location.func_110623_a());
        }

        public ResourceLocation func_147650_b() {
            return this.location;
        }

        public boolean func_147657_c() {
            if (Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.nextSound)) {
                SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
                SoundCategory category = SoundCategory.func_147154_a((String)this.nextChannel());
                handler.func_147684_a(category, 1.0f);
            }
            return false;
        }

        public int func_147652_d() {
            return 0;
        }

        public float func_147653_e() {
            return 1.0f;
        }

        public float func_147655_f() {
            return 1.0f;
        }

        public float func_147649_g() {
            return 0.0f;
        }

        public float func_147654_h() {
            return 0.0f;
        }

        public float func_147651_i() {
            return 0.0f;
        }

        public ISound.AttenuationType func_147656_j() {
            return ISound.AttenuationType.NONE;
        }

        public boolean isDonePlaying() {
            return false;
        }

        public void update() {
            if (++this.current == this.offset) {
                BGMPlayer.this.prepareContinueLoop(this);
            }
        }

        private SoundLoop next() {
            return this.nextSound;
        }

        private String nextChannel() {
            return this.location.func_110624_b().equals("bgm1") ? "bgm2" : "bgm1";
        }
    }
}

