/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.seril;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.List;
import net.infstudio.infinitylib.api.seril.NBTDeserializer;
import net.infstudio.infinitylib.api.seril.NBTSerializer;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTBasement
implements NBTDeserializer.Base<Object>,
NBTSerializer.Base<Object> {
    private static NBTBasement instance;
    private ImmutableList<FullSerializer> built_in;
    private ImmutableMap<Class, FullSerializer> built_in_map;

    public static NBTBasement instance() {
        if (instance == null) {
            instance = new NBTBasement();
        }
        return instance;
    }

    public ImmutableList<FullSerializer> getList() {
        return this.built_in;
    }

    @Override
    public Object deserialize(NBTBase base) {
        if (base == null) {
            return null;
        }
        if (base.func_74732_a() == 10) {
            throw new IllegalArgumentException("Cannot directly deserialize an NBTTagCompound!");
        }
        if (base.func_74732_a() == 9) {
            throw new IllegalArgumentException("Cannot directly deserialize an NBTTagList!");
        }
        return ((NBTDeserializer.Base)TypeUtils.cast(this.built_in.get((int)base.func_74732_a()))).deserialize(base);
    }

    @Override
    public NBTBase serialize(Object data) {
        FullSerializer serializer = (FullSerializer)this.built_in_map.get(data.getClass());
        if (serializer != null) {
            return ((NBTSerializer)TypeUtils.cast(serializer)).serialize(data);
        }
        return null;
    }

    private NBTBasement() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        listBuilder.add((Object)new FullSerializer<Void>(){

            @Override
            public NBTBase serialize(Void data) {
                return null;
            }

            @Override
            public Void deserialize(NBTBase base) {
                return null;
            }
        }).add((Object)new FullSerializer<Byte>(){

            public NBTBase.NBTPrimitive serialize(Byte data) {
                return new NBTTagByte(data.byteValue());
            }

            @Override
            public Byte deserialize(NBTBase base) {
                return ((NBTBase.NBTPrimitive)base).func_150290_f();
            }
        }).add((Object)new FullSerializer<Short>(){

            public NBTBase.NBTPrimitive serialize(Short data) {
                return new NBTTagShort(data.shortValue());
            }

            @Override
            public Short deserialize(NBTBase base) {
                return ((NBTBase.NBTPrimitive)base).func_150289_e();
            }
        }).add((Object)new FullSerializer<Integer>(){

            public NBTBase.NBTPrimitive serialize(Integer data) {
                return new NBTTagInt(data.intValue());
            }

            @Override
            public Integer deserialize(NBTBase base) {
                return ((NBTBase.NBTPrimitive)base).func_150287_d();
            }
        }).add((Object)new FullSerializer<Long>(){

            public NBTBase.NBTPrimitive serialize(Long data) {
                return new NBTTagLong(data.longValue());
            }

            @Override
            public Long deserialize(NBTBase base) {
                return ((NBTBase.NBTPrimitive)base).func_150291_c();
            }
        }).add((Object)new FullSerializer<Float>(){

            public NBTBase.NBTPrimitive serialize(Float data) {
                return new NBTTagFloat(data.floatValue());
            }

            @Override
            public Float deserialize(NBTBase base) {
                return Float.valueOf(((NBTBase.NBTPrimitive)base).func_150288_h());
            }
        }).add((Object)new FullSerializer<Double>(){

            public NBTBase.NBTPrimitive serialize(Double data) {
                return new NBTTagDouble(data.doubleValue());
            }

            @Override
            public Double deserialize(NBTBase base) {
                return ((NBTBase.NBTPrimitive)base).func_150286_g();
            }
        }).add((Object)new FullSerializer<byte[]>(){

            public NBTTagByteArray serialize(byte[] data) {
                return new NBTTagByteArray(data);
            }

            @Override
            public byte[] deserialize(NBTBase base) {
                return ((NBTTagByteArray)base).func_150292_c();
            }
        }).add((Object)new FullSerializer<String>(){

            public NBTTagString serialize(String data) {
                return new NBTTagString(data);
            }

            @Override
            public String deserialize(NBTBase base) {
                return ((NBTTagString)base).func_150285_a_();
            }
        }).add((Object)new FullSerializer<List>(){

            @Override
            public NBTBase serialize(List data) {
                return null;
            }

            @Override
            public List deserialize(NBTBase base) {
                return null;
            }
        }).add((Object)new FullSerializer<Object>(){

            @Override
            public Object deserialize(NBTBase base) {
                return null;
            }

            public NBTTagCompound serialize(Object data) {
                NBTTagCompound tag = new NBTTagCompound();
                Class<?> clz = data.getClass();
                for (Field field : clz.getDeclaredFields()) {
                    if (!field.isAccessible()) continue;
                    try {
                        Object f = field.get(data);
                        tag.func_74782_a(field.getName(), null);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                return tag;
            }
        }).add((Object)new FullSerializer<int[]>(){

            public NBTTagIntArray serialize(int[] data) {
                return new NBTTagIntArray(data);
            }

            @Override
            public int[] deserialize(NBTBase base) {
                return ((NBTTagIntArray)base).func_150302_c();
            }
        });
        this.built_in = listBuilder.build();
        for (FullSerializer fullSerializer : this.built_in) {
            mapBuilder.put(TypeUtils.getInterfaceGenericTypeTo(fullSerializer), (Object)fullSerializer);
        }
        this.built_in_map = mapBuilder.build();
    }

    static interface FullSerializer<T>
    extends NBTDeserializer.Base<T>,
    NBTSerializer.Base<T> {
    }
}

