/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.remote.gui.node;

import java.util.List;
import net.infstudio.infinitylib.api.Pipeline;
import net.infstudio.infinitylib.api.remote.gui.Properties;
import net.infstudio.infinitylib.api.remote.gui.components.GuiComponent;
import net.infstudio.infinitylib.api.remote.gui.node.DrawNode;
import net.infstudio.infinitylib.api.vars.Var;
import net.infstudio.infinitylib.api.vars.VarForward;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;

public class DrawBorder
extends Gui
implements DrawNode {
    public static final DrawBorder INSTANCE = new DrawBorder();

    private DrawBorder() {
    }

    private int calculateHeight(List<CharSequence> contents) {
        int height = 8;
        if (contents.size() > 1) {
            height += 2 + (contents.size() - 1) * 10;
        }
        return height;
    }

    private int calculateWidth(List<CharSequence> contents) {
        int width = 0;
        for (CharSequence s : contents) {
            int sLength = Minecraft.func_71410_x().field_71466_p.func_78256_a(s.toString());
            if (sLength <= width) continue;
            width = sLength;
        }
        return width;
    }

    @Override
    public void draw(GuiComponent.Transform transform, Pipeline<DrawNode> pipeline, Properties properties) {
        int width;
        int height;
        VarForward property = null;
        if (!property.isPresent()) {
            return;
        }
        List contents = (List)property.get();
        if (contents.isEmpty()) {
            return;
        }
        String HEIGHT = "border_height";
        String WIDTH = "border_width";
        Var heightContainer = (Var)properties.getCache(HEIGHT);
        Var widthContainer = (Var)properties.getCache(WIDTH);
        if (heightContainer.get() == null) {
            height = this.calculateHeight(contents);
            heightContainer.set(height);
        } else {
            height = (Integer)heightContainer.get();
        }
        if (widthContainer.get() == null) {
            width = this.calculateWidth(contents);
            widthContainer.set(width);
        } else {
            width = (Integer)widthContainer.get();
        }
        int screenWidth = Minecraft.func_71410_x().field_71462_r.field_146294_l;
        int screenHeight = Minecraft.func_71410_x().field_71462_r.field_146295_m;
        int xLeft = transform.x + 12;
        int yLeft = transform.y - 12;
        if (xLeft + width > screenWidth) {
            xLeft -= 28 + width;
        }
        if (yLeft + height + 6 > screenHeight) {
            yLeft = screenHeight - height - 6;
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.field_73735_i = 300.0f;
        RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
        itemRender.field_77023_b = 300.0f;
        int borderColor = -267386864;
        this.func_73733_a(xLeft - 3, yLeft - 4, xLeft + width + 3, yLeft - 3, borderColor, borderColor);
        this.func_73733_a(xLeft - 3, yLeft + height + 3, xLeft + width + 3, yLeft + height + 4, borderColor, borderColor);
        this.func_73733_a(xLeft - 3, yLeft - 3, xLeft + width + 3, yLeft + height + 3, borderColor, borderColor);
        this.func_73733_a(xLeft - 4, yLeft - 3, xLeft - 3, yLeft + height + 3, borderColor, borderColor);
        this.func_73733_a(xLeft + width + 3, yLeft - 3, xLeft + width + 4, yLeft + height + 3, borderColor, borderColor);
        int startColor = 0x505000FF;
        int endColor = (startColor & 0xFEFEFE) >> 1 | startColor & 0xFF000000;
        this.func_73733_a(xLeft - 3, yLeft - 3 + 1, xLeft - 3 + 1, yLeft + height + 3 - 1, startColor, endColor);
        this.func_73733_a(xLeft + width + 2, yLeft - 3 + 1, xLeft + width + 3, yLeft + height + 3 - 1, startColor, endColor);
        this.func_73733_a(xLeft - 3, yLeft - 3, xLeft + width + 3, yLeft - 3 + 1, startColor, startColor);
        this.func_73733_a(xLeft - 3, yLeft + height + 2, xLeft + width + 3, yLeft + height + 3, endColor, endColor);
        this.field_73735_i = 0.0f;
        itemRender.field_77023_b = 0.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }
}

