/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.remote.gui.components;

import com.google.common.collect.Lists;
import java.util.List;
import net.infstudio.infinitylib.api.Pipeline;
import net.infstudio.infinitylib.api.remote.gui.ComponentRepository;
import net.infstudio.infinitylib.api.remote.gui.Properties;
import net.infstudio.infinitylib.api.remote.gui.node.DrawNode;
import net.infstudio.infinitylib.api.remote.gui.plugins.Plugin;
import net.minecraft.inventory.Container;

public class GuiComponent {
    protected Transform transform = new Transform();
    private Pipeline<DrawNode> drawPipe;
    private Properties properties;
    private List<Plugin> plugins;
    private GuiComponent parent;
    protected List<GuiComponent> children;

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = ComponentRepository.repository.newProperty();
        }
        return this.properties;
    }

    public GuiComponent getParent() {
        return this.parent;
    }

    protected List<Plugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = Lists.newArrayList();
        }
        return this.plugins;
    }

    protected Pipeline<DrawNode> getDrawPipe() {
        if (this.drawPipe == null) {
            this.drawPipe = ComponentRepository.repository.newDrawPipe();
        }
        return this.drawPipe;
    }

    public GuiComponent add(GuiComponent component) {
        this.children.add(component);
        component.parent = this;
        return this;
    }

    public void applyPlugin(Plugin plugin) {
        if (this.plugins != null) {
            this.plugins = Lists.newArrayList();
        }
        plugin.plugin(this);
        this.plugins.add(plugin);
    }

    public void disposePlugin(Plugin plugin) {
        if (this.plugins == null) {
            return;
        }
        if (!this.plugins.contains(plugin)) {
            return;
        }
        plugin.dispose();
        this.plugins.remove(plugin);
    }

    public void draw() {
        for (DrawNode drawNode : this.drawPipe) {
            drawNode.draw(this.transform, this.drawPipe, this.properties);
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (GuiComponent child : this.children) {
                child.draw();
            }
        }
    }

    public void onLoad(Container container) {
    }

    protected void finalize() throws Throwable {
        for (Plugin plugin : this.plugins) {
            plugin.dispose();
        }
        super.finalize();
    }

    public GuiComponent setPosRelative(int x, int y) {
        this.transform.x = this.parent == null ? 0 : this.parent.transform.x + x;
        this.transform.y = this.parent == null ? 0 : this.parent.transform.y + y;
        return this;
    }

    public int getRelativeX() {
        return this.transform.x - (this.parent == null ? 0 : this.parent.transform.x);
    }

    public int getRelativeY() {
        return this.transform.y - (this.parent == null ? 0 : this.parent.transform.y);
    }

    public Transform transform() {
        if (this.transform == null) {
            this.transform = this.parent != null ? new Transform(this.parent.transform()) : new Transform();
        }
        return this.transform;
    }

    public class Transform {
        public int x;
        public int y;
        public int width;
        public int height;

        public Transform() {
        }

        public Transform(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public Transform(Transform transform) {
            this.setPos(transform);
            this.setSize(transform);
        }

        public void offset(int x, int y) {
            this.x += x;
            this.y += y;
        }

        public void setPos(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void setPos(Transform transform) {
            this.x = transform.x;
            this.y = transform.y;
        }

        public void setSize(int width, int height) {
            this.height = height;
            this.width = width;
        }

        public void setSize(Transform transform) {
            this.width = transform.width;
            this.height = transform.height;
        }
    }
}

