/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.remote.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.infstudio.infinitylib.api.gui.ComponentProvider;
import net.infstudio.infinitylib.api.remote.gui.components.GuiComponent;
import net.infstudio.infinitylib.api.remote.gui.components.GuiTextureBlock;
import net.infstudio.infinitylib.api.remote.gui.event.ClickEvent;
import net.infstudio.infinitylib.api.remote.gui.event.DragEvent;
import net.infstudio.infinitylib.api.remote.gui.event.HoverEvent;
import net.infstudio.infinitylib.api.utils.GuiUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GuiContainerCommon
extends GuiContainer {
    protected List<GuiComponent> front;
    protected List<GuiComponent> back;
    protected GuiComponent current;
    protected boolean adjusted;
    protected MouseEvent currentState;

    public GuiContainerCommon(Container container) {
        super(container);
    }

    public GuiContainerCommon loadGui(ComponentProvider provider) {
        if (this.front != null) {
            this.front.clear();
        }
        if (this.back != null) {
            this.back.clear();
        }
        for (Object o : this.field_147002_h.field_75151_b) {
            Slot slot = (Slot)o;
            this.back.add(new GuiTextureBlock(GuiUtil.slot, slot.field_75223_e, slot.field_75221_f));
        }
        return this;
    }

    public GuiContainerCommon(Container inventorySlotsIn, ComponentProvider provider) {
        super(inventorySlotsIn);
        ArrayList components = Lists.newArrayList();
        for (Object o : inventorySlotsIn.field_75151_b) {
            Slot slot = (Slot)o;
            this.back.add(new GuiTextureBlock(GuiUtil.slot, slot.field_75223_e, slot.field_75221_f));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.current != null) {
            MinecraftForge.EVENT_BUS.post((Event)new ClickEvent(this.currentState, this.current, (GuiScreen)this));
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.current != null) {
            MinecraftForge.EVENT_BUS.post((Event)new ClickEvent.Release(this.currentState, this.current, (GuiScreen)this));
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.current != null) {
            MinecraftForge.EVENT_BUS.post((Event)new DragEvent(this.currentState, this.current, (GuiScreen)this));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.adjusted) {
            this.adjusted = true;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        for (GuiComponent guiComponent : this.front) {
            guiComponent.draw();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        for (GuiComponent guiComponent : this.back) {
            guiComponent.draw();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        boolean checked = false;
        if (this.current != null) {
            if (this.include(this.current, mouseX, mouseY)) {
                checked = true;
                MinecraftForge.EVENT_BUS.post((Event)new HoverEvent(this.currentState, this.current, (GuiScreen)this));
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new HoverEvent.End(this.currentState, this.current, (GuiScreen)this));
            }
        }
        for (GuiComponent component : this.front) {
            if (checked || !this.include(component, mouseX, mouseY)) continue;
            checked = true;
            this.current = component;
        }
        for (GuiComponent component : this.back) {
            if (checked || !this.include(component, mouseX, mouseY)) continue;
            checked = true;
            this.current = component;
        }
    }

    protected boolean include(GuiComponent gui, int x, int y) {
        return this.func_146978_c(gui.transform().x, gui.transform().y, gui.transform().width, gui.transform().height, x, y);
    }

    public void accept(MouseEvent event) {
        this.currentState = event;
    }
}

