/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.remote.container;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.Callback;
import net.infstudio.infinitylib.api.gui.ComponentProvider;
import net.infstudio.infinitylib.api.inventory.Inventory;
import net.infstudio.infinitylib.api.inventory.InventoryElement;
import net.infstudio.infinitylib.api.network.ModNetwork;
import net.infstudio.infinitylib.api.remote.Syncable;
import net.infstudio.infinitylib.api.remote.capabilities.CapabilitiesCommon;
import net.infstudio.infinitylib.api.remote.gui.Properties;
import net.infstudio.infinitylib.api.remote.gui.components.GuiComponent;
import net.infstudio.infinitylib.api.seril.ITagSerializable;
import net.infstudio.infinitylib.api.vars.VarForward;
import net.infstudio.infinitylib.api.vars.VarSync;
import net.infstudio.infinitylib.inventory.SlotRuled;
import net.infstudio.infinitylib.network.SyncMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerBase
extends Container
implements Callback<VarSync> {
    private ImmutableList<? extends VarSync> syncs;
    private ImmutableList<GuiComponent> components;
    private String ownerId;

    public ContainerBase load(World world, ICapabilityProvider provider) {
        Syncable syncable;
        Inventory inv = (Inventory)provider.getCapability(CapabilitiesCommon.INVENTORY, null);
        if (inv != null) {
            for (InventoryElement element : inv) {
                this.loadSlots(SlotRuled.of(element));
            }
        }
        if ((syncable = (Syncable)provider.getCapability(CapabilitiesCommon.SYNC, null)) != null) {
            this.load(syncable.getAllSync());
        }
        ComponentProvider componentProvider = (ComponentProvider)provider.getCapability(CapabilitiesCommon.COMPONENTS, null);
        ArrayList list = Lists.newArrayList();
        componentProvider.provideComponents(list);
        this.components = ImmutableList.copyOf((Collection)list);
        this.ownerId = provider.getClass().getSimpleName();
        if (!world.field_72995_K) {
            for (GuiComponent component : this.components) {
                for (Properties.Key key : component.getProperties().allProperties()) {
                    VarForward prop = null;
                    Object v = prop.get();
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            this.revolveConnection(o);
                        }
                        continue;
                    }
                    if (v instanceof Iterable) {
                        for (Object o : (Iterable)v) {
                            this.revolveConnection(o);
                        }
                        continue;
                    }
                    this.revolveConnection(prop.delegate());
                }
            }
        }
        return this;
    }

    private void revolveConnection(Object o) {
        if (!(o instanceof VarSync)) {
            return;
        }
        int i = this.syncs.indexOf(o);
        if (i != -1) {
            // empty if block
        }
    }

    public ContainerBase loadPlayer(EntityPlayer player) {
        return this.loadPlayer(player, 0, 0);
    }

    public ContainerBase loadPlayer(EntityPlayer player, int startX, int startY) {
        int index;
        if (player == null) {
            player = HelperMod.proxy.getPlayer();
        }
        for (index = 0; index < 9; ++index) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, index, startX + 8 + index * 18, startY + 142));
        }
        for (index = 0; index < 3; ++index) {
            for (int offset = 0; offset < 9; ++offset) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, offset + index * 9 + 9, startX + 8 + offset * 18, startY + 84 + index * 18));
            }
        }
        return this;
    }

    private ContainerBase loadSlots(List<? extends Slot> slots) {
        for (Slot slot : slots) {
            this.func_75146_a(slot);
        }
        return this;
    }

    private ContainerBase load(List<VarSync> syncs) {
        this.syncs = ImmutableList.copyOf(syncs);
        for (VarSync sync : syncs) {
            sync.add(this);
        }
        return this;
    }

    public List<EntityPlayerMP> getPlayers() {
        ArrayList players = Lists.newArrayList();
        for (Object o : this.field_75149_d) {
            if (!(o instanceof EntityPlayerMP)) continue;
            players.add((EntityPlayerMP)o);
        }
        return players;
    }

    public void func_75132_a(ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)iCrafting;
            for (int num = 0; num < this.syncs.size(); ++num) {
                ModNetwork.instance().sendTo(new SyncMessage(this.field_75152_c, num, (ITagSerializable)this.syncs.get(num)), playerMP);
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
    }

    public void onInventoryChange(IInventory inventoryIn) {
        this.func_75130_a(inventoryIn);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return false;
    }

    @Override
    public void onChange(VarSync varSync) {
        if (this.syncs.contains((Object)varSync)) {
            int i = this.syncs.indexOf((Object)varSync);
            for (EntityPlayerMP playerMP : this.getPlayers()) {
                ModNetwork.instance().sendTo(new SyncMessage(this.field_75152_c, i, varSync), playerMP);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void load(int id, NBTTagCompound tag) {
        ((VarSync)this.syncs.get(id)).readFromNBT(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void load(Collection<GuiComponent> components) {
    }
}

