/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.registry;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;
import net.infstudio.infinitylib.api.utils.ASMDataUtil;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public abstract class ASMRegistryDelegate<T extends Annotation> {
    protected Set<ASMCache> cache = Sets.newHashSet();
    private Iterator<ASMCache> itr;
    private ASMCache current;

    public boolean hasNext() {
        if (this.itr == null) {
            this.itr = this.cache.iterator();
        }
        return this.itr.hasNext();
    }

    public void next() {
        if (this.itr == null) {
            this.itr = this.cache.iterator();
        }
        this.current = this.itr.next();
    }

    protected Class<?> getAnnotatedClass() {
        return this.current.clz;
    }

    protected String getModid() {
        return this.current.modid;
    }

    protected T getAnnotation() {
        return this.current.annotation;
    }

    protected Optional<Object> getObject() {
        return this.current.target;
    }

    protected Optional<Field> getField() {
        return this.current.field;
    }

    public final void addCache(String modid, ASMDataTable.ASMData data) {
        if (modid == null) {
            modid = ASMDataUtil.getModId(data);
        }
        Class<?> clz = ASMDataUtil.getClass(data);
        Class type = TypeUtils.getGenericTypeTo(this);
        Object annotation = ASMDataUtil.getAnnotation(data, type);
        Optional f = Optional.fromNullable((Object)ASMDataUtil.getField(data));
        Optional<Object> o = ASMDataUtil.getObject(data);
        this.cache.add(new ASMCache(this, clz, modid, annotation, o, f));
    }

    static class ASMCache {
        Class<?> clz;
        String modid;
        T annotation;
        Optional<Object> target;
        Optional<Field> field;
        final /* synthetic */ ASMRegistryDelegate this$0;

        public ASMCache(Class<?> clz, String modid, T annotation, Optional<Object> target, Optional<Field> field) {
            this.this$0 = this$0;
            this.clz = clz;
            this.modid = modid;
            this.annotation = annotation;
            this.target = target;
            this.field = field;
        }
    }
}

