/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.network;

import io.netty.buffer.ByteBuf;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.network.MessageCoder;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

abstract class AbstractMessage<T>
implements IMessageHandler<AbstractMessage<T>, IMessage>,
IMessage {
    protected final MessageCoder<T> delegate;

    public AbstractMessage(MessageCoder<T> coder) {
        this.delegate = coder;
    }

    public abstract IMessage handleClientMessage(EntityPlayer var1, T var2, MessageContext var3);

    public abstract IMessage handleServerMessage(EntityPlayer var1, T var2, MessageContext var3);

    public IMessage onMessage(AbstractMessage<T> message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            return this.handleClientMessage(HelperMod.proxy.getPlayer(), message.delegate.get(), ctx);
        }
        return this.handleServerMessage((EntityPlayer)ctx.getServerHandler().field_147369_b, message.delegate.get(), ctx);
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getSinglePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void toBytes(ByteBuf buf) {
        if (this.delegate != null) {
            this.delegate.toBytes(buf);
        }
    }

    public void fromBytes(ByteBuf buf) {
        if (this.delegate != null) {
            this.delegate.fromBytes(buf);
        }
    }
}

