/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.minecraft;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.infstudio.infinitylib.api.minecraft.TileEntityWrap;
import net.infstudio.infinitylib.api.seril.ITagSerializer;
import net.infstudio.infinitylib.api.vars.Var;
import net.infstudio.infinitylib.api.vars.VarSyncBase;
import net.infstudio.infinitylib.inventory.InventoryBuilderImpl;
import net.minecraft.nbt.NBTTagCompound;

public class TileBuilderImpl {
    private InventoryBuilderImpl builder = new InventoryBuilderImpl();
    private TileEntityWrap tileEntityWrap;
    private ArrayList<VarSyncBase> varSyncs = new ArrayList();

    public TileBuilderImpl(TileEntityWrap tileEntityWrap) {
        this.tileEntityWrap = tileEntityWrap;
    }

    void done() {
        this.tileEntityWrap.inventory = this.builder.buildInventory();
        this.tileEntityWrap.varSync = ImmutableList.copyOf(this.varSyncs);
    }

    public <T> Var<T> newSyncVar(T initValue, final ITagSerializer<T> serializer) {
        VarSyncBase sync = new VarSyncBase<T>(){

            @Override
            public void readFromNBT(NBTTagCompound tag) {
                this.set(serializer.readFromNBT(tag, this.get()));
            }

            @Override
            public void writeToNBT(NBTTagCompound tag) {
                serializer.writeToNBT(tag, this.get());
            }
        };
        sync.set(initValue);
        this.varSyncs.add(sync);
        return sync;
    }
}

