/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.io.cache;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Runnables;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.infstudio.infinitylib.api.Instance;
import net.infstudio.infinitylib.api.LoadingDelegate;
import net.infstudio.infinitylib.api.utils.FileReference;
import net.infstudio.infinitylib.client.loading.ExternalResource;
import net.infstudio.infinitylib.client.loading.PackBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.commons.io.FileUtils;

@LoadingDelegate
public class CacheSystem {
    @Instance
    public static final CacheSystem INSTANCE = new CacheSystem();
    private File root = FileReference.getDir(FileReference.mc, "cache");
    ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private Multimap<String, ResourceLocation> cache = HashMultimap.create();
    private Map<ResourceLocation, ListenableFuture<File>> pending = Maps.newHashMap();

    private CacheSystem() {
    }

    public ListenableFuture<File> cachePresisit(final ResourceLocation location, URL url) throws IOException {
        if (this.pending.containsKey(location)) {
            return this.pending.get(location);
        }
        if (!this.hasCached(location)) {
            ListenableFuture future = this.service.submit((Callable)new DownloadTask(this.getCacheFile(location), url, true));
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    CacheSystem.this.pending.remove(location);
                }
            }, (Executor)this.service);
            return future;
        }
        return ListenableFutureTask.create((Runnable)Runnables.doNothing(), (Object)this.getCacheFile(location));
    }

    public ListenableFuture<File> cache(final ResourceLocation location, URL url) throws IOException {
        if (this.pending.containsKey(location)) {
            return this.pending.get(location);
        }
        if (!this.hasCached(location)) {
            ListenableFuture future = this.service.submit((Callable)new DownloadTask(this.getCacheFile(location), url, false));
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    CacheSystem.this.pending.remove(location);
                }
            }, (Executor)this.service);
            return future;
        }
        return ListenableFutureTask.create((Runnable)Runnables.doNothing(), (Object)this.getCacheFile(location));
    }

    public boolean hasCached(ResourceLocation location) {
        return this.cache.containsEntry((Object)location.func_110624_b(), (Object)location);
    }

    public boolean isPending(ResourceLocation location) {
        return this.pending.containsKey(location);
    }

    public void remove(final ResourceLocation location) {
        if (this.cache.containsEntry((Object)location.func_110624_b(), (Object)location)) {
            this.service.submit(new Runnable(){

                @Override
                public void run() {
                    CacheSystem.this.cache.remove((Object)location.func_110624_b(), (Object)location);
                    FileUtils.deleteQuietly((File)CacheSystem.this.getCacheFile(location));
                }
            });
        }
    }

    public void clear(final String domain) {
        if (this.cache.containsKey((Object)domain)) {
            this.service.submit(new Runnable(){

                @Override
                public void run() {
                    File dir = new File(CacheSystem.this.root, domain);
                    if (dir.exists()) {
                        FileUtils.deleteQuietly((File)dir);
                        CacheSystem.this.cache.removeAll((Object)domain);
                    }
                }
            });
        }
    }

    public File getCacheFile(ResourceLocation location) {
        return new File(FileReference.getDir(this.root, location.func_110624_b()), location.func_110623_a());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ExternalResource.register(new PackBase(this.root){

            @Override
            public Set<String> domain() {
                return Sets.newHashSet((Object[])new String[]{"cache"});
            }
        });
        for (File domain : this.root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            for (File f : domain.listFiles()) {
                this.buildLoc(f, domain.getName(), "");
            }
        }
    }

    private void buildLoc(File file, String domain, String currentPath) {
        if (file.isDirectory()) {
            for (File next : file.listFiles()) {
                this.buildLoc(next, domain, currentPath.concat(file.getName()));
            }
        } else {
            this.cache.put((Object)domain, (Object)new ResourceLocation(domain, currentPath.concat(file.getName())));
        }
    }

    public static class DownloadTask
    implements Callable<File> {
        private File file;
        private URL url;
        private boolean persist;

        public DownloadTask(File file, URL url, boolean persist) {
            this.file = file;
            this.url = url;
            this.persist = persist;
        }

        @Override
        public File call() throws Exception {
            ReadableByteChannel channel = Channels.newChannel(this.url.openStream());
            FileOutputStream cacheFile = new FileOutputStream(this.file);
            cacheFile.getChannel().transferFrom(channel, 0L, Integer.MAX_VALUE);
            cacheFile.close();
            if (!this.persist) {
                this.file.deleteOnExit();
            }
            return this.file;
        }
    }
}

