/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.io;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import net.infstudio.infinitylib.api.utils.FileReference;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.IThreadedFileIO;
import net.minecraft.world.storage.ThreadedFileIOBase;

public class IOSystem {
    public static void save(ResourceLocation location, NBTTagCompound data) {
        IOSystem.save(location, data, false);
    }

    public static void save(ResourceLocation location, NBTTagCompound data, boolean compressed) {
        ThreadedFileIOBase.func_178779_a().func_75735_a((IThreadedFileIO)new SaveTask(data, IOSystem.getPath(location), compressed));
    }

    public static ListenableFuture<NBTTagCompound> load(ResourceLocation location, boolean compressed) {
        File path = IOSystem.getPath(location);
        ReadTask task = new ReadTask(path, compressed);
        ThreadedFileIOBase.func_178779_a().func_75735_a((IThreadedFileIO)task);
        return task.getFuture();
    }

    public static ListenableFuture<NBTTagCompound> load(ResourceLocation location) {
        return IOSystem.load(location, false);
    }

    private static File getPath(ResourceLocation location) {
        File domain = FileReference.getDir(FileReference.getSave(), location.func_110624_b());
        return new File(domain, location.func_110623_a().concat(".dat"));
    }

    private static class SaveTask
    implements IThreadedFileIO {
        NBTTagCompound data;
        File path;
        boolean compressed;

        public SaveTask(NBTTagCompound serializable, File path, boolean compressed) {
            this.data = serializable;
            this.path = path;
            this.compressed = compressed;
        }

        public boolean func_75814_c() {
            try {
                if (this.compressed) {
                    CompressedStreamTools.func_74799_a((NBTTagCompound)this.data, (OutputStream)new FileOutputStream(this.path));
                } else {
                    CompressedStreamTools.func_74795_b((NBTTagCompound)this.data, (File)this.path);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }

    private static class ReadTask
    implements IThreadedFileIO {
        NBTTagCompound data;
        File path;
        boolean compressed;
        ListenableFutureTask<NBTTagCompound> task;

        public ReadTask(File path, boolean compressed) {
            this.path = path;
            this.compressed = compressed;
            this.task = ListenableFutureTask.create((Callable)new Callable<NBTTagCompound>(){

                @Override
                public NBTTagCompound call() throws Exception {
                    return ReadTask.this.data;
                }
            });
        }

        ListenableFuture<NBTTagCompound> getFuture() {
            return this.task;
        }

        public boolean func_75814_c() {
            try {
                this.data = !this.compressed ? CompressedStreamTools.func_74797_a((File)this.path) : CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(this.path));
                this.task.run();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

