/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api;

import com.google.common.base.Optional;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface Instance {
    public boolean weak() default false;

    public static class Utils {
        public static <T> Optional<T> grab(Class<T> clz) {
            for (Field field : clz.getDeclaredFields()) {
                Instance annotation = field.getAnnotation(Instance.class);
                if (annotation == null) continue;
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers)) {
                    HelperMod.LOG.fatal("The field annotated by Instance should be static! cannot grab the instance.");
                    return Optional.absent();
                }
                if (!field.getType().isAssignableFrom(clz)) {
                    HelperMod.LOG.fatal("Illegal field type! The type {} cannot cast to type {}", new Object[]{clz, field.getType()});
                    return Optional.absent();
                }
                Object o = null;
                if (Modifier.isPrivate(modifiers)) {
                    o = ReflectionHelper.getPrivateValue(clz, null, (String[])new String[]{field.getName()});
                } else {
                    try {
                        o = TypeUtils.cast(field.get(null));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                if (o == null && !annotation.weak()) {
                    try {
                        o = clz.newInstance();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                return Optional.fromNullable(o);
            }
            return Optional.absent();
        }
    }
}

