/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.taskman.impl;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.incongru.taskman.TaskSweeper;
import net.incongru.taskman.TaskSweeperRunner;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

public class SingleThreadedTaskSweeperRunner
implements TaskSweeperRunner {
    private final TaskSweeper sweeper;
    private final Period period;

    public SingleThreadedTaskSweeperRunner(TaskSweeper theSweeper, Period period) {
        this.sweeper = theSweeper;
        this.period = period;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                SingleThreadedTaskSweeperRunner.this.sweeper.sweepAndRemind();
            }
        }, 0L, this.getDurationInMillis(period), TimeUnit.MILLISECONDS);
    }

    public Period getPeriod() {
        return this.period;
    }

    private long getDurationInMillis(Period period) {
        return period.toDurationFrom((ReadableInstant)new DateTime()).getMillis();
    }

    public static void main(String[] args) {
        TaskSweeper ts = new TaskSweeper(){
            private int count = 0;

            public void sweepAndRemind() {
                System.out.print(new DateTime());
                System.out.println("  ++count : " + ++this.count);
                if (this.count % 8 == 0) {
                    throw new RuntimeException("I hate 8's");
                }
            }
        };
        Period p = Period.seconds((int)2);
        System.out.println("p = " + p);
        System.out.println("p.getMillis() = " + p.getMillis());
        new SingleThreadedTaskSweeperRunner(ts, p);
    }
}

