/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.taskman.hibernate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.incongru.taskman.Assignee;
import net.incongru.taskman.TaskEvent;
import net.incongru.taskman.TaskInstance;
import net.incongru.taskman.TaskInstanceImpl;
import net.incongru.taskman.TaskLogImpl;
import net.incongru.taskman.TaskMan;
import net.incongru.taskman.action.TaskAction;
import net.incongru.taskman.action.TaskActionManager;
import net.incongru.taskman.action.TaskContext;
import net.incongru.taskman.def.TaskDef;
import net.incongru.taskman.def.TaskDefImpl;
import net.incongru.taskman.def.TaskDefParser;
import net.incongru.taskman.id.IdGenerator;
import net.incongru.taskman.id.NullIdGenerator;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatedTaskMan
implements TaskMan {
    private static final Criterion PENDING_TASK_STATUS = Expression.not((Criterion)Expression.in((String)"status", Arrays.asList(TaskEvent.cancelled, TaskEvent.stopped)));
    private static final Long DEFAULT_VERSION_ID = new Long(1L);
    private final Session session;
    private final TaskActionManager actionManager;
    private final IdGenerator idGenerator;

    public HibernatedTaskMan(Session session, TaskActionManager actionManager) {
        this(session, actionManager, new NullIdGenerator());
    }

    public HibernatedTaskMan(Session session, TaskActionManager actionManager, IdGenerator idGenerator) {
        this.session = session;
        this.actionManager = actionManager;
        this.idGenerator = idGenerator;
    }

    @Override
    public TaskDef deployTaskDef(TaskDefParser taskDefParser, boolean forceEvenIfEquals) {
        TaskDef taskDef = taskDefParser.loadTaskDesk();
        assert (taskDef instanceof TaskDefImpl);
        assert (taskDef.getId() == null);
        assert (taskDef.getVersionId() == null);
        assert (taskDef.getDeploymentDateTime() == null);
        TaskDef latestTaskDef = this.findLatestTaskDef(taskDef.getName());
        if (!forceEvenIfEquals && taskDef.isSameAs(latestTaskDef)) {
            return latestTaskDef;
        }
        Long newVersion = DEFAULT_VERSION_ID;
        if (latestTaskDef != null) {
            newVersion = latestTaskDef.getVersionId() + 1L;
        }
        taskDef.setVersionId(newVersion);
        taskDef.setDeploymentDateTime(new DateTime());
        this.session.save((Object)taskDef);
        return taskDef;
    }

    private TaskDef findLatestTaskDef(String taskDefName) {
        Criteria criteria = this.session.createCriteria(TaskDefImpl.class);
        criteria.add((Criterion)Expression.eq((String)"name", (Object)taskDefName));
        criteria.addOrder(Order.desc((String)"versionId"));
        criteria.setMaxResults(1);
        return (TaskDef)criteria.uniqueResult();
    }

    @Override
    public TaskInstance getTaskById(String taskId) {
        return (TaskInstance)this.session.load(TaskInstanceImpl.class, (Serializable)((Object)taskId));
    }

    @Override
    public List<TaskInstance> getTasksByReporterId(String actorId) {
        Criteria criteria = this.session.createCriteria(TaskInstanceImpl.class);
        criteria.add((Criterion)Expression.eq((String)"reporter", (Object)actorId));
        return criteria.list();
    }

    @Override
    public List<TaskInstance> getPendingTasksByReporterId(String actorId) {
        Criteria criteria = this.session.createCriteria(TaskInstanceImpl.class);
        criteria.add((Criterion)Expression.eq((String)"reporter", (Object)actorId));
        criteria.add(PENDING_TASK_STATUS);
        return criteria.list();
    }

    @Override
    public List<TaskInstance> getTasksByAssignee(Assignee assignee) {
        Criteria criteria = this.session.createCriteria(TaskInstanceImpl.class);
        criteria.add((Criterion)Expression.eq((String)"assignee", (Object)assignee));
        return criteria.list();
    }

    @Override
    public List<TaskInstance> getPendingTasksByAssignee(Assignee assignee) {
        Criteria criteria = this.session.createCriteria(TaskInstanceImpl.class);
        criteria.add((Criterion)Expression.eq((String)"assignee", (Object)assignee));
        criteria.add(PENDING_TASK_STATUS);
        return criteria.list();
    }

    @Override
    public TaskInstance newTaskInstance(String taskDefName, String reporterId, String taskId, String taskName, String taskDesc) {
        TaskDef taskDef = this.findLatestTaskDef(taskDefName);
        if (taskDef == null) {
            throw new IllegalStateException("TaskDef with name " + taskDefName + " does not exist.");
        }
        TaskInstanceImpl task = new TaskInstanceImpl();
        if (taskId == null) {
            task.setId(this.idGenerator.generate());
        } else {
            task.setId(taskId);
        }
        task.setName(taskName);
        task.setDescription(taskDesc);
        task.setTaskDef(taskDef);
        task.setReporter(reporterId);
        this.logAndDispatchSimpleEvent(task, TaskEvent.instanciated, null, null);
        task.setStatus(TaskEvent.instanciated);
        this.session.save((Object)task);
        return task;
    }

    @Override
    public void assign(TaskInstance task, Assignee newAssignee) {
        assert (task instanceof TaskInstanceImpl);
        Assignee previousAssignee = task.getAssignee();
        ((TaskInstanceImpl)task).setAssignee(newAssignee);
        this.logAndDispatchSimpleEvent(task, TaskEvent.assigned, this.toString(previousAssignee), this.toString(task.getAssignee()));
        ((TaskInstanceImpl)task).setStatus(TaskEvent.assigned);
        this.session.save((Object)task);
    }

    @Override
    public void start(TaskInstance task) {
        this.logAndDispatchSimpleEvent(task, TaskEvent.started, null, null);
        ((TaskInstanceImpl)task).setStatus(TaskEvent.started);
        this.session.save((Object)task);
    }

    @Override
    public void cancel(TaskInstance task) {
        this.logAndDispatchSimpleEvent(task, TaskEvent.cancelled, null, null);
        ((TaskInstanceImpl)task).setStatus(TaskEvent.cancelled);
        this.session.save((Object)task);
    }

    @Override
    public void stop(TaskInstance task) {
        this.logAndDispatchSimpleEvent(task, TaskEvent.stopped, null, null);
        ((TaskInstanceImpl)task).setStatus(TaskEvent.stopped);
        this.session.save((Object)task);
    }

    @Override
    public void addVariable(TaskInstance task, String name, Object value) {
        assert (task instanceof TaskInstanceImpl);
        TaskInstanceImpl taskImpl = (TaskInstanceImpl)task;
        Object oldValue = taskImpl.getVariables().put(name, value);
        this.logAndDispatchSimpleEvent(task, TaskEvent.variableAdded, name + "=" + this.toString(oldValue), name + "=" + this.toString(value));
        this.session.save((Object)task);
    }

    @Override
    public List<TaskInstance> findRemainingTasks() {
        Criteria criteria = this.session.createCriteria(TaskInstance.class);
        throw new IllegalStateException("not implemented yet");
    }

    private void logAndDispatchSimpleEvent(TaskInstance task, TaskEvent event, String oldValue, String newValue) {
        TaskLogImpl taskLog = new TaskLogImpl();
        taskLog.setDateTime(new DateTime());
        taskLog.setTaskEvent(event);
        taskLog.setOldValue(oldValue);
        taskLog.setNewValue(newValue);
        task.getLog().add(taskLog);
        TaskAction taskAction = this.actionManager.getTaskAction(task, event);
        if (taskAction != null) {
            TaskContextImpl ctx = new TaskContextImpl(task, event);
            taskAction.execute(ctx);
        }
    }

    private String toString(Object value) {
        return value != null ? value.toString() : null;
    }

    protected final class TaskContextImpl
    implements TaskContext {
        private TaskInstance task;
        private TaskEvent event;

        private TaskContextImpl(TaskInstance task, TaskEvent event) {
            this.task = task;
            this.event = event;
        }

        public void assignTask(Assignee assignee) {
            HibernatedTaskMan.this.assign(this.task, assignee);
        }

        public void addTaskVariable(String name, Object value) {
            HibernatedTaskMan.this.addVariable(this.task, name, value);
        }

        public void startTask() {
            HibernatedTaskMan.this.start(this.task);
        }

        public void stopTask() {
            HibernatedTaskMan.this.stop(this.task);
        }

        public void cancelTask() {
            HibernatedTaskMan.this.cancel(this.task);
        }

        public TaskInstance getTask() {
            return this.task;
        }

        public TaskEvent getEvent() {
            return this.event;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("TaskContextImpl");
            sb.append("{event=").append((Object)this.event);
            sb.append(",task=").append(this.task);
            sb.append('}');
            return sb.toString();
        }
    }
}

