/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.taskman.def.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import net.incongru.taskman.TaskEvent;
import net.incongru.taskman.def.TaskDef;
import net.incongru.taskman.def.TaskDefImpl;
import net.incongru.taskman.def.TaskDefParser;
import net.incongru.taskman.def.xstream.PeriodConverter;
import net.incongru.util.io.Flusher;
import net.incongru.util.io.IOProcessor;

public class XStreamTaskDefParser
implements TaskDefParser {
    private InputStream in;

    public XStreamTaskDefParser(InputStream in) {
        this.in = in;
    }

    public TaskDef loadTaskDesk() {
        XStream xStream = this.getXStream();
        return (TaskDef)xStream.fromXML((Reader)new InputStreamReader(this.in));
    }

    public void storeTaskDef(final TaskDef taskDef, String fullPathForOutput) throws IOException {
        final FileWriter out = new FileWriter(fullPathForOutput);
        new Flusher().processFlushAndClose((Closeable)out, (IOProcessor)new IOProcessor<FileWriter>(){

            public void process(FileWriter c) {
                XStream xStream = XStreamTaskDefParser.this.getXStream();
                xStream.toXML((Object)taskDef, (Writer)out);
            }
        });
    }

    private XStream getXStream() {
        XStream xStream = new XStream();
        xStream.registerConverter((Converter)new PeriodConverter());
        xStream.alias("TaskDef", TaskDefImpl.class);
        xStream.alias("TaskEvent", TaskEvent.class);
        return xStream;
    }
}

