/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.user.hibernate;

import java.io.Serializable;
import java.util.Date;
import net.incongru.berkano.user.User;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class UpdateDateInterceptor
extends EmptyInterceptor {
    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof User) {
            this.findAndSetTimeStamp("creationTimestamp", propertyNames, state);
            return true;
        }
        return false;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (entity instanceof User) {
            this.findAndSetTimeStamp("updateTimestamp", propertyNames, currentState);
            return true;
        }
        return false;
    }

    private void findAndSetTimeStamp(String propertyName, String[] propertyNames, Object[] state) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyName.equals(propertyNames[i])) continue;
            state[i] = new Date();
            break;
        }
    }
}

