/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.user.hibernate;

import java.io.Serializable;
import java.util.List;
import net.incongru.berkano.security.password.PasswordMatchingStrategy;
import net.incongru.berkano.user.DuplicateUserException;
import net.incongru.berkano.user.GroupImpl;
import net.incongru.berkano.user.PropertiesAware;
import net.incongru.berkano.user.UnknownUserException;
import net.incongru.berkano.user.User;
import net.incongru.berkano.user.UserDAO;
import net.incongru.berkano.user.UserImpl;
import net.incongru.berkano.user.hibernate.AbstractHibernatedDAO;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;

public class HibernatedUserDAO
extends AbstractHibernatedDAO
implements UserDAO {
    private final PasswordMatchingStrategy passwordMatchingStrategy;

    public HibernatedUserDAO(Session session, PasswordMatchingStrategy passwordMatchingStrategy) {
        super(session);
        this.passwordMatchingStrategy = passwordMatchingStrategy;
    }

    protected PropertiesAware getById(Long id) throws UnknownUserException {
        return (PropertiesAware)((Object)this.getUserById(id));
    }

    protected Class getUserClass() {
        return UserImpl.class;
    }

    protected UserImpl newInstance() {
        return new UserImpl();
    }

    public void addProperty(User user, String propertyKey, Object value) throws UnknownUserException {
        this.session.lock((Object)user, LockMode.NONE);
        ((UserImpl)user).getProperties().put(propertyKey, value);
        this.session.save((Object)user);
    }

    public User getUserById(Long userId) throws UnknownUserException {
        User user = (User)this.session.get(this.getUserClass(), (Serializable)userId);
        if (user == null) {
            throw new UnknownUserException(userId);
        }
        return user;
    }

    public User getUserByName(String userName) {
        return this.getUserByField("userName", userName);
    }

    public User getUserByEmail(String email) {
        return this.getUserByField("email", email);
    }

    private User getUserByField(String fieldName, String value) {
        Criteria criteria = this.session.createCriteria(this.getUserClass());
        criteria.add((Criterion)Expression.eq((String)fieldName, (Object)value).ignoreCase());
        return (User)criteria.uniqueResult();
    }

    public boolean removeUser(Long userId) throws UnknownUserException {
        UserImpl user = (UserImpl)this.session.load(this.getUserClass(), (Serializable)userId);
        if (user == null) {
            throw new UnknownUserException(userId);
        }
        this.session.delete((Object)user);
        return true;
    }

    public List listAllUsers() {
        return this.session.createCriteria(this.getUserClass()).list();
    }

    public User newUser(String userName, String cleanPassword, String email, String fullName) {
        User existingUser = this.getUserByName(userName);
        if (existingUser != null) {
            throw new DuplicateUserException(userName);
        }
        UserImpl newUser = this.newInstance();
        newUser.setUserName(userName);
        newUser.setPassword(this.passwordMatchingStrategy.encode(cleanPassword));
        newUser.setEmail(email);
        newUser.setFullName(fullName);
        this.session.save((Object)newUser);
        return newUser;
    }

    public User updateUser(Long userId, String userName, String email, String fullName) throws UnknownUserException {
        UserImpl user = (UserImpl)this.getUserById(userId);
        user.setUserName(userName);
        user.setFullName(fullName);
        user.setEmail(email);
        this.session.update((Object)user);
        return user;
    }

    public void updateUser(User user) {
        this.session.update((Object)user);
    }

    public void changePassword(Long userId, String newPassword) throws UnknownUserException {
        UserImpl user = (UserImpl)this.getUserById(userId);
        user.setPassword(this.passwordMatchingStrategy.encode(newPassword));
        this.session.update((Object)user);
    }

    public void addToGroup(Long userId, Long groupId) throws UnknownUserException {
        GroupImpl group = (GroupImpl)this.session.get(GroupImpl.class, (Serializable)groupId);
        UserImpl user = (UserImpl)this.getUserById(userId);
        user.getGroups().add(group);
        group.getUsers().add(user);
        this.session.save((Object)user);
    }

    public void removeFromGroup(Long userId, Long groupId) throws UnknownUserException {
        GroupImpl group = (GroupImpl)this.session.get(GroupImpl.class, (Serializable)groupId);
        UserImpl user = (UserImpl)this.getUserById(userId);
        user.getGroups().remove(group);
        group.getUsers().remove(user);
        this.session.save((Object)user);
    }
}

