/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.user.hibernate;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import net.incongru.berkano.user.Group;
import net.incongru.berkano.user.GroupDAO;
import net.incongru.berkano.user.GroupImpl;
import net.incongru.berkano.user.PropertiesAware;
import net.incongru.berkano.user.UnknownUserException;
import net.incongru.berkano.user.hibernate.AbstractHibernatedDAO;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;

public class HibernatedGroupDAO
extends AbstractHibernatedDAO
implements GroupDAO {
    public HibernatedGroupDAO(Session session) {
        super(session);
    }

    protected PropertiesAware getById(Long id) throws UnknownUserException {
        return (PropertiesAware)((Object)this.getGroupById(id));
    }

    public Group getGroupById(Long groupId) {
        return (Group)this.session.get(GroupImpl.class, (Serializable)groupId);
    }

    public Group getGroupByName(String groupName) {
        Criteria criteria = this.session.createCriteria(GroupImpl.class);
        criteria.add((Criterion)Expression.eq((String)"groupName", (Object)groupName).ignoreCase());
        return (Group)criteria.uniqueResult();
    }

    public Group newGroup(String groupName) {
        GroupImpl g = new GroupImpl();
        g.setGroupName(groupName);
        this.session.save((Object)g);
        return g;
    }

    public boolean removeGroup(Long groupId) {
        Object group = this.session.load(GroupImpl.class, (Serializable)groupId);
        this.session.delete(group);
        return true;
    }

    public List listAllGroups() {
        return this.session.createCriteria(GroupImpl.class).list();
    }

    public void assignRoles(Long groupId, Set roles) {
        GroupImpl g = (GroupImpl)this.getGroupById(groupId);
        g.setRoles(roles);
        this.session.save((Object)g);
    }
}

