/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.security.password.retrieval;

import net.incongru.berkano.security.password.PasswordGenerator;
import net.incongru.berkano.security.password.retrieval.AbstractMailPasswordRetrievalStrategy;
import net.incongru.berkano.user.User;
import net.incongru.berkano.user.UserDAO;
import net.incongru.util.mail.MailBean;
import net.incongru.util.mail.Mailer;

public class MailNewPasswordRetrievalStrategy
extends AbstractMailPasswordRetrievalStrategy {
    private final UserDAO userDAO;
    private final PasswordGenerator passwordGenerator;

    public MailNewPasswordRetrievalStrategy(UserDAO userDAO, PasswordGenerator passwordGenerator, Mailer mailer) {
        super(mailer);
        this.userDAO = userDAO;
        this.passwordGenerator = passwordGenerator;
    }

    protected void prepareMailContext(User u, MailBean mail) {
        super.prepareMailContext(u, mail);
        String newPassword = this.passwordGenerator.generate();
        mail.getValues().put("newPassword", newPassword);
        this.userDAO.changePassword(u.getUserId(), newPassword);
    }

    protected String getMailSubject() {
        return "NewPassword";
    }

    protected String getTemplateName() {
        return "berkano/lostpw/mail/new_password";
    }
}

