/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.security.password.retrieval;

import java.util.HashMap;
import net.incongru.berkano.security.password.PasswordRetrievalStrategy;
import net.incongru.berkano.user.User;
import net.incongru.util.mail.MailBean;
import net.incongru.util.mail.Mailer;

public abstract class AbstractMailPasswordRetrievalStrategy
implements PasswordRetrievalStrategy {
    private final Mailer mailer;

    protected AbstractMailPasswordRetrievalStrategy(Mailer mailer) {
        this.mailer = mailer;
    }

    public void retrievePassword(User u) throws Exception {
        HashMap map = new HashMap();
        MailBean mail = new MailBean(u.getEmail(), u.getFullName(), this.getMailSubject(), this.getTemplateName(), map);
        this.prepareMailContext(u, mail);
        this.mailer.mail(mail);
    }

    protected void prepareMailContext(User u, MailBean mail) {
        mail.getValues().put("user", u);
    }

    protected abstract String getMailSubject();

    protected abstract String getTemplateName();

    public String getRequiredField() {
        return "email";
    }
}

