/*
 * Decompiled with CFR 0.152.
 */
package net.incongru.berkano.app;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.incongru.berkano.app.Application;

public class ApplicationsProvider {
    private final String defaultAppName;
    private final Map<String, Application> appsMap;

    public ApplicationsProvider(Application[] apps) {
        if (apps.length < 1) {
            throw new IllegalStateException("No Application was registered");
        }
        this.defaultAppName = apps[0].getName();
        this.appsMap = new HashMap<String, Application>(apps.length);
        for (Application app : apps) {
            this.appsMap.put(app.getName(), app);
        }
    }

    public Application getApp(String appName) {
        Application app;
        if (appName == null) {
            appName = this.defaultAppName;
        }
        if ((app = this.appsMap.get(appName)) == null) {
            throw new IllegalArgumentException("Unknown Application name");
        }
        return app;
    }

    public Collection getAllApps() {
        return this.appsMap.values();
    }
}

