/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.swagger.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Resource;
import net.ifok.swagger.model.SwaggerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.DocExpansion;
import springfox.documentation.swagger.web.ModelRendering;
import springfox.documentation.swagger.web.OperationsSorter;
import springfox.documentation.swagger.web.TagsSorter;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Configuration
@EnableSwagger2WebMvc
public class SwaggerConfig
implements BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfig.class);
    public static final String DOCKET_POST_SUFFIX = "_API_DOCKET_NAME";
    private BeanFactory beanFactory;
    @Resource
    SwaggerProperties swaggerProperties;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public SwaggerConfig() {
        log.info("SwaggerConfig init ....");
    }

    private Docket defaultDocket() {
        List<SwaggerProperties.GlobalParam> globalParams;
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        docket = docket.enable(this.swaggerProperties.getEnabled().booleanValue());
        docket = docket.apiInfo(this.getApiInfo(this.swaggerProperties.getApiTitle(), this.swaggerProperties.getApiDescription(), this.swaggerProperties.getTermsOfServiceUrl(), this.swaggerProperties.getApiVersion(), this.swaggerProperties.getLicense(), this.swaggerProperties.getLicenseUrl(), this.swaggerProperties.getContact()));
        if (!StringUtils.isEmpty((Object)this.swaggerProperties.getUrlPattern())) {
            docket = docket.select().paths(PathSelectors.ant((String)this.swaggerProperties.getUrlPattern())).build();
        }
        if (Objects.nonNull(this.swaggerProperties.getPackages()) && this.swaggerProperties.getPackages().length > 0) {
            docket = docket.select().apis(SwaggerConfig.basePackage(Arrays.asList(this.swaggerProperties.getPackages()))).build();
        }
        if ((globalParams = this.swaggerProperties.getGlobalParams()) != null && globalParams.size() > 0) {
            ParameterBuilder ticketPar = new ParameterBuilder();
            ArrayList<Parameter> pars = new ArrayList<Parameter>();
            for (SwaggerProperties.GlobalParam globalParam : globalParams) {
                ticketPar.name(globalParam.getParamName()).description(globalParam.getParamDesc()).defaultValue(globalParam.getParamExample()).modelRef((ModelReference)new ModelRef(globalParam.getDataType())).parameterType(globalParam.getParamType()).required(globalParam.isRequired()).build();
                pars.add(ticketPar.build());
                docket.globalOperationParameters(pars);
            }
        }
        if (CollectionUtils.isEmpty(this.swaggerProperties.getGlobalResponseMessages())) {
            RequestMethod[] requestMethods = RequestMethod.values();
            for (RequestMethod requestMethod : requestMethods) {
                docket.globalResponseMessage(requestMethod, Collections.singletonList(new ResponseMessageBuilder().code(200).message("Ok").build()));
            }
        } else {
            List<SwaggerProperties.GlobalResponseMessage> globalResponseMessages = this.swaggerProperties.getGlobalResponseMessages();
            for (SwaggerProperties.GlobalResponseMessage globalResponseMessage : globalResponseMessages) {
                List<SwaggerProperties.CodeMessage> codeMessages = globalResponseMessage.getCodeMessages();
                if (CollectionUtils.isEmpty(codeMessages)) continue;
                ArrayList<ResponseMessage> messageList = new ArrayList<ResponseMessage>();
                for (SwaggerProperties.CodeMessage codeMessage : codeMessages) {
                    messageList.add(new ResponseMessageBuilder().code(codeMessage.getCode()).message(codeMessage.getMessage()).build());
                }
                docket.globalResponseMessage(globalResponseMessage.getMethod(), messageList);
            }
        }
        return docket;
    }

    @Bean
    @ConditionalOnMissingBean
    public List<Docket> apiDockets() {
        String docPath = this.swaggerProperties.getDocPath();
        if (!StringUtils.isEmpty((Object)docPath)) {
            System.setProperty("springfox.documentation.swagger.v2.path", docPath);
        }
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        ArrayList<Docket> dockets = new ArrayList<Docket>();
        if (!this.swaggerProperties.getEnabled().booleanValue()) {
            Docket docket = new Docket(DocumentationType.SWAGGER_2);
            docket = docket.enable(this.swaggerProperties.getEnabled().booleanValue());
            configurableBeanFactory.registerSingleton("defaultDocket", (Object)docket);
            dockets.add(docket);
            return dockets;
        }
        Map<String, SwaggerProperties.DocketInfo> group = this.swaggerProperties.getGroup();
        if (CollectionUtils.isEmpty(group)) {
            Docket docket = this.defaultDocket();
            configurableBeanFactory.registerSingleton("defaultDocket", (Object)docket);
            dockets.add(docket);
            return dockets;
        }
        Set<String> groupKeys = group.keySet();
        for (String groupKey : groupKeys) {
            SwaggerProperties.DocketInfo docketInfo = group.get(groupKey);
            Docket docket = this.getDocket(docketInfo, groupKey);
            configurableBeanFactory.registerSingleton(groupKey + DOCKET_POST_SUFFIX, (Object)docket);
            dockets.add(docket);
        }
        return dockets;
    }

    private Docket getDocket(SwaggerProperties.DocketInfo docketInfo, String groupName) {
        List<SwaggerProperties.GlobalParam> globalParams;
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        String docketInfoGroupName = docketInfo.getGroupName();
        if (StringUtils.isEmpty((Object)docketInfoGroupName)) {
            docketInfoGroupName = groupName;
        }
        docket.groupName(docketInfoGroupName);
        docket = docket.apiInfo(this.getApiInfo(docketInfo.getApiTitle(), docketInfo.getApiDescription(), docketInfo.getTermsOfServiceUrl(), docketInfo.getApiVersion(), docketInfo.getLicense(), docketInfo.getLicenseUrl(), docketInfo.getContact()));
        if (!StringUtils.isEmpty((Object)docketInfo.getUrlPattern())) {
            docket = docket.select().paths(PathSelectors.ant((String)docketInfo.getUrlPattern())).build();
        }
        if (Objects.nonNull(docketInfo.getPackages()) && docketInfo.getPackages().length > 0) {
            docket = docket.select().apis(SwaggerConfig.basePackage(Arrays.asList(docketInfo.getPackages()))).build();
        }
        if ((globalParams = this.swaggerProperties.getGlobalParams()) != null && globalParams.size() > 0) {
            ParameterBuilder ticketPar = new ParameterBuilder();
            ArrayList<Parameter> pars = new ArrayList<Parameter>();
            for (SwaggerProperties.GlobalParam globalParam : globalParams) {
                ticketPar.name(globalParam.getParamName()).description(globalParam.getParamDesc()).defaultValue(globalParam.getParamExample()).modelRef((ModelReference)new ModelRef(globalParam.getDataType())).parameterType(globalParam.getParamType()).required(globalParam.isRequired()).build();
                pars.add(ticketPar.build());
                docket.globalOperationParameters(pars);
            }
        }
        if (CollectionUtils.isEmpty(this.swaggerProperties.getGlobalResponseMessages())) {
            RequestMethod[] requestMethods = RequestMethod.values();
            for (RequestMethod requestMethod : requestMethods) {
                docket.globalResponseMessage(requestMethod, Collections.singletonList(new ResponseMessageBuilder().code(200).message("Ok").build()));
            }
        } else {
            List<SwaggerProperties.GlobalResponseMessage> globalResponseMessages = this.swaggerProperties.getGlobalResponseMessages();
            for (SwaggerProperties.GlobalResponseMessage globalResponseMessage : globalResponseMessages) {
                List<SwaggerProperties.CodeMessage> codeMessages = globalResponseMessage.getCodeMessages();
                if (CollectionUtils.isEmpty(codeMessages)) continue;
                ArrayList<ResponseMessage> messageList = new ArrayList<ResponseMessage>();
                for (SwaggerProperties.CodeMessage codeMessage : codeMessages) {
                    messageList.add(new ResponseMessageBuilder().code(codeMessage.getCode()).message(codeMessage.getMessage()).build());
                }
                docket.globalResponseMessage(globalResponseMessage.getMethod(), messageList);
            }
        }
        return docket;
    }

    private ApiInfo getApiInfo(String title, String description, String termsOfServiceUrl, String version, String license, String licenseUrl, SwaggerProperties.Contact contact) {
        return new ApiInfoBuilder().title(title).description(description).termsOfServiceUrl(termsOfServiceUrl).version(version).license(license).licenseUrl(licenseUrl).contact(new Contact(contact.getName(), contact.getUrl(), contact.getEmail())).build();
    }

    public static Predicate<RequestHandler> basePackage(List<String> packages) {
        return input -> SwaggerConfig.declaringClass(input).map(SwaggerConfig.handlerPackage(packages)).orElse(true);
    }

    private static Function<Class<?>, Boolean> handlerPackage(List<String> packages) {
        return input -> {
            for (String strPackage : packages) {
                boolean isMatch = input.getPackage().getName().startsWith(strPackage);
                if (!isMatch) continue;
                return true;
            }
            return false;
        };
    }

    private static Optional<Class<?>> declaringClass(RequestHandler input) {
        return Optional.ofNullable(input.declaringClass());
    }

    @Bean
    UiConfiguration swaggerUIConfig() {
        return UiConfigurationBuilder.builder().deepLinking(Boolean.valueOf(true)).displayOperationId(Boolean.valueOf(false)).defaultModelsExpandDepth(Integer.valueOf(0)).defaultModelExpandDepth(Integer.valueOf(Integer.MAX_VALUE)).defaultModelRendering(ModelRendering.MODEL).displayRequestDuration(Boolean.valueOf(true)).docExpansion(DocExpansion.LIST).filter((Object)false).maxDisplayedTags(null).operationsSorter(OperationsSorter.ALPHA).showExtensions(Boolean.valueOf(false)).tagsSorter(TagsSorter.ALPHA).validatorUrl(null).build();
    }
}

