/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.project.swagger.config;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.ifok.project.swagger.model.SwaggerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.DocExpansion;
import springfox.documentation.swagger.web.ModelRendering;
import springfox.documentation.swagger.web.OperationsSorter;
import springfox.documentation.swagger.web.TagsSorter;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger.web.UiConfigurationBuilder;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Configuration
@EnableSwagger2WebMvc
public class SwaggerConfig {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfig.class);
    @Autowired
    SwaggerProperties swaggerProperties;

    public SwaggerConfig() {
        log.info("SwaggerConfig init ....");
    }

    @Bean
    @ConditionalOnMissingBean
    public Docket swaggerDataConfig() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        docket = docket.enable(this.swaggerProperties.getEnabled().booleanValue());
        docket = docket.apiInfo(this.apiInfo());
        if (!StringUtils.isEmpty((Object)this.swaggerProperties.getUrlPattern())) {
            docket = docket.select().paths(PathSelectors.ant((String)this.swaggerProperties.getUrlPattern())).build();
        }
        if (!CollectionUtils.isEmpty(this.swaggerProperties.getPackages())) {
            docket = docket.select().apis(SwaggerConfig.basePackage(this.swaggerProperties.getPackages())).build();
        }
        return docket;
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerProperties.getApiTitle()).description(this.swaggerProperties.getApiDescription()).termsOfServiceUrl(this.swaggerProperties.getApiUrl()).version(this.swaggerProperties.getApiVersion()).build();
    }

    public static Predicate<RequestHandler> basePackage(List<String> packages) {
        return input -> SwaggerConfig.declaringClass(input).map(SwaggerConfig.handlerPackage(packages)).orElse(true);
    }

    private static Function<Class<?>, Boolean> handlerPackage(List<String> packages) {
        return input -> {
            for (String strPackage : packages) {
                boolean isMatch = input.getPackage().getName().startsWith(strPackage);
                if (!isMatch) continue;
                return true;
            }
            return false;
        };
    }

    private static Optional<Class<?>> declaringClass(RequestHandler input) {
        return Optional.ofNullable(input.declaringClass());
    }

    @Bean
    UiConfiguration swaggerUIConfig() {
        return UiConfigurationBuilder.builder().deepLinking(Boolean.valueOf(true)).displayOperationId(Boolean.valueOf(false)).defaultModelsExpandDepth(Integer.valueOf(0)).defaultModelExpandDepth(Integer.valueOf(Integer.MAX_VALUE)).defaultModelRendering(ModelRendering.MODEL).displayRequestDuration(Boolean.valueOf(true)).docExpansion(DocExpansion.LIST).filter((Object)false).maxDisplayedTags(null).operationsSorter(OperationsSorter.ALPHA).showExtensions(Boolean.valueOf(false)).tagsSorter(TagsSorter.ALPHA).validatorUrl(null).build();
    }
}

