/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.project.stateless.shiro.filter;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.ifok.project.stateless.shiro.model.StatelessShiroProperties;
import net.ifok.project.stateless.shiro.service.StatelessSessionUserService;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class StatelessAccessControlFilter
extends AccessControlFilter {
    private static final Logger log = LoggerFactory.getLogger(StatelessAccessControlFilter.class);
    @Autowired
    StatelessShiroProperties statelessShiroProperties;
    @Autowired
    StatelessSessionUserService statelessSessionUserService;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        String token = req.getHeader(this.statelessShiroProperties.getTokenName());
        if (StringUtils.isEmpty((Object)token)) {
            token = request.getParameter(this.statelessShiroProperties.getTokenName());
        }
        final String finalToken = token;
        AuthenticationToken authenticationToken = new AuthenticationToken(){

            public Object getPrincipal() {
                return finalToken;
            }

            public Object getCredentials() {
                return finalToken;
            }
        };
        try {
            this.getSubject(request, response).login(authenticationToken);
        }
        catch (Exception e) {
            this.returnLoginError(response);
            return false;
        }
        return true;
    }

    private void returnLoginError(ServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter writer = response.getWriter();
        writer.write(JSON.toJSONString(this.statelessSessionUserService.unAuthentication()));
    }
}

