/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.project.stateless.shiro.config;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import net.ifok.project.stateless.shiro.config.StatelessDefaultSubjectFactory;
import net.ifok.project.stateless.shiro.config.StatelessRealm;
import net.ifok.project.stateless.shiro.filter.StatelessAccessControlFilter;
import net.ifok.project.stateless.shiro.model.StatelessShiroProperties;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.DelegatingFilterProxy;

@Configuration
public class StatelessShiroConfig {
    private static final Logger log = LoggerFactory.getLogger(StatelessShiroConfig.class);
    static final String DEFAULT_URL = "/**";
    static final String ANON = "anon";
    static final String STATELESS_FILTER_NAME = "statelessAuthc";
    static final String STATELESS_FILTER_FACTORY_NAME = "shiroFilterFactoryBean";
    @Autowired
    StatelessShiroProperties statelessShiroProperties;

    @Bean
    public StatelessRealm userRealm() {
        StatelessRealm realm = new StatelessRealm();
        realm.setCachingEnabled(false);
        return realm;
    }

    @Bean
    public StatelessDefaultSubjectFactory subjectFactory() {
        return new StatelessDefaultSubjectFactory();
    }

    @Bean
    public SessionManager sessionManager() {
        DefaultSessionManager sessionManager = new DefaultSessionManager();
        sessionManager.setSessionValidationSchedulerEnabled(false);
        return sessionManager;
    }

    @Bean
    public SessionStorageEvaluator sessionStorageEvaluator() {
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        return defaultSessionStorageEvaluator;
    }

    @Bean
    public SecurityManager securityManager(StatelessRealm statelessRealm, SessionStorageEvaluator sessionStorageEvaluator, SubjectFactory subjectFactory, SessionManager sessionManager) {
        DefaultWebSecurityManager defaultSecurityManager = new DefaultWebSecurityManager();
        defaultSecurityManager.setRealm((Realm)statelessRealm);
        DefaultSubjectDAO defaultSubjectDAO = new DefaultSubjectDAO();
        defaultSubjectDAO.setSessionStorageEvaluator(sessionStorageEvaluator);
        defaultSecurityManager.setSubjectDAO((SubjectDAO)defaultSubjectDAO);
        defaultSecurityManager.setSubjectFactory(subjectFactory);
        defaultSecurityManager.setSessionManager(sessionManager);
        return defaultSecurityManager;
    }

    @Bean
    public StatelessAccessControlFilter statelessAuthcFilter() {
        StatelessAccessControlFilter statelessAuthcFilter = new StatelessAccessControlFilter();
        return statelessAuthcFilter;
    }

    @Bean(name={"shiroFilterFactoryBean"})
    public ShiroFilterFactoryBean shiroFilterFactoryBean(SecurityManager securityManager, StatelessAccessControlFilter statelessAccessControlFilter) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        HashMap<String, StatelessAccessControlFilter> filters = new HashMap<String, StatelessAccessControlFilter>();
        filters.put(STATELESS_FILTER_NAME, statelessAccessControlFilter);
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> filterChainDefinitionMap = new LinkedHashMap<String, String>();
        List<String> urlExcludes = this.statelessShiroProperties.getUrlExcludes();
        if (!CollectionUtils.isEmpty(urlExcludes)) {
            log.info("Shiro URL Excludes : {}", (Object)JSON.toJSONString(urlExcludes));
            for (String urlExclude : urlExcludes) {
                filterChainDefinitionMap.put(urlExclude, ANON);
            }
        } else {
            log.info("Shiro URL Excludes Is Empty .");
        }
        List<String> urlPatterns = this.statelessShiroProperties.getUrlPatterns();
        if (CollectionUtils.isEmpty(urlPatterns)) {
            log.warn("Shiro urlPatterns is empty,set default /**");
            filterChainDefinitionMap.put(DEFAULT_URL, STATELESS_FILTER_NAME);
        } else {
            for (String urlPattern : urlPatterns) {
                filterChainDefinitionMap.put(urlPattern, STATELESS_FILTER_NAME);
            }
        }
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }

    @Bean
    public FilterRegistrationBean delegatingFilterProxy() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        DelegatingFilterProxy proxy = new DelegatingFilterProxy();
        proxy.setTargetFilterLifecycle(true);
        proxy.setTargetBeanName(STATELESS_FILTER_FACTORY_NAME);
        filterRegistrationBean.setFilter((Filter)proxy);
        return filterRegistrationBean;
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }
}

