/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.png.compress;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.imageio.ImageIO;
import net.ifok.png.compress.PngEncoder;

public class PngCompressor {
    private static final String FILENAME = "_compressed";
    private static boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private static byte[] getCompressedImageAsByteArray(BufferedImage image, int inputLen) throws IOException {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream(inputLen / 2);
        PngEncoder encoder = new PngEncoder();
        encoder.setCompressed(true);
        encoder.write(image, tempStream);
        tempStream.flush();
        tempStream.close();
        return tempStream.toByteArray();
    }

    private static void writeSizeMessage(int originalSize, int compressedSize) {
        String diffMessage;
        if (originalSize == compressedSize) {
            diffMessage = " (same size)";
        } else {
            float diff = 1.0f - (float)compressedSize / (float)originalSize;
            diff *= 100.0f;
            if (originalSize > compressedSize) {
                diffMessage = " (" + String.format("%.02f", Float.valueOf(diff)) + "% smaller)";
            } else {
                diff = -diff;
                diffMessage = " (" + String.format("%.02f", Float.valueOf(diff)) + "% larger)";
            }
        }
        System.out.println("Original size: " + originalSize);
        System.out.println("Compressed size: " + compressedSize + diffMessage);
    }

    public static void compress(File input, File output) throws IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(input);
        }
        catch (IOException e) {
            System.out.println("error: Failed to read image " + input.getAbsolutePath());
            throw new IOException(e);
        }
        if (image == null) {
            throw new IOException("error: Failed to read image " + input.getAbsolutePath());
        }
        int inputLen = (int)input.length();
        byte[] compressedImage = PngCompressor.getCompressedImageAsByteArray(image, inputLen);
        if (verbose) {
            System.out.println("Input: " + input.getAbsolutePath());
            System.out.println("Output: " + output.getAbsolutePath());
            PngCompressor.writeSizeMessage(inputLen, compressedImage.length);
        }
        if (compressedImage.length < inputLen) {
            if (verbose) {
                System.out.println("Writing compressed image");
            }
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(output));
            outputStream.write(compressedImage);
            outputStream.flush();
            outputStream.close();
        } else if (!input.equals(output)) {
            if (verbose) {
                System.out.println("Writing original image (compressed image is not smaller)");
            }
            PngCompressor.copyFile(input, output);
        } else if (verbose) {
            System.out.println("Compressed image is not smaller, not overwriting");
        }
        if (verbose) {
            System.out.println();
        }
    }

    public static void compress(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedImage image;
        byte[] originalImage = PngCompressor.getByteArrayFromInputStream(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(originalImage);
        try {
            image = ImageIO.read(byteArrayInputStream);
        }
        catch (IOException e) {
            System.out.println("error: Failed to read image");
            throw new IOException(e);
        }
        if (image == null) {
            throw new IOException("error: Failed to read image");
        }
        byte[] compressedImage = PngCompressor.getCompressedImageAsByteArray(image, originalImage.length);
        if (verbose) {
            PngCompressor.writeSizeMessage(originalImage.length, compressedImage.length);
        }
        if (compressedImage.length < originalImage.length) {
            if (verbose) {
                System.out.println("Returning compressed image");
            }
            outputStream.write(compressedImage);
        } else {
            if (verbose) {
                System.out.println("Returning original image (compressed image is not smaller)");
            }
            outputStream.write(originalImage);
        }
        if (verbose) {
            System.out.println();
        }
    }

    private static byte[] getByteArrayFromInputStream(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        buffer.close();
        return buffer.toByteArray();
    }

    private static boolean processFile(File inputFile, boolean overwrite) {
        String fileLocation = inputFile.getAbsolutePath();
        if (inputFile.exists()) {
            if (fileLocation.toLowerCase().endsWith(".png")) {
                File outputFile;
                if (overwrite) {
                    outputFile = inputFile;
                } else {
                    int extIndex = fileLocation.length() - 4;
                    outputFile = new File(fileLocation.substring(0, extIndex) + FILENAME + fileLocation.substring(extIndex));
                }
                try {
                    PngCompressor.compress(inputFile, outputFile);
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            System.out.println("error: " + fileLocation + " is not a png file.");
            return false;
        }
        System.out.println("error: " + fileLocation + " does not exist.");
        return false;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            PngCompressor.showCommandLineHelp();
        } else {
            boolean failed = false;
            verbose = "true".equalsIgnoreCase(System.getProperty("verbose"));
            boolean overwrite = "true".equalsIgnoreCase(System.getProperty("overwrite"));
            for (String arg : args) {
                boolean success = PngCompressor.processFile(new File(arg), overwrite);
                if (success) continue;
                failed = true;
            }
            if (failed) {
                System.exit(1);
            }
        }
    }

    private static void showCommandLineHelp() {
        System.out.println("How to run PngCompressor:\n\n    java [options] -jar jdeli.jar compresspng [pngfile [pngfile ...]]\n\n        options:\n            1. -Doverwrite=true       overwrite input files (default: \"false\")\n            2. -Dverbose=true         print status messages (default: \"false\")\n\n    Examples:\n        java -jar jdeli.jar compresspng file.png\n\n        java -Doverwrite=true -jar jdeli.jar compresspng /directory/*.png\n\n        java -Dverbose=true -jar jdeli.jar compresspng /directory/*.png\n\n    The output filename is the same as the input name except that _compressed\n    will be appended to the name. E.g. file.png will become file_compressed.png\n    This can be changed to overwrite the existing file by setting the overwrite\n    setting to true.");
    }
}

