/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.png.compress;

import java.io.IOException;
import java.io.OutputStream;

public class BitWriter {
    private int bitCount;
    private int pointer;
    private final OutputStream stream;

    public BitWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void end() {
        while (this.bitCount > 0) {
            this.pointer <<= 1;
            ++this.bitCount;
            if (this.bitCount != 8) continue;
            try {
                this.stream.write(this.pointer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.pointer = 0;
            this.bitCount = 0;
        }
    }

    public void writeBits(int bits, int num) {
        if (num < 0 || num > 32) {
            throw new IllegalArgumentException("Number of bits is out of range");
        }
        while (num > 0) {
            int cbit = Math.min(num, 8 - this.bitCount);
            this.pointer = this.pointer << cbit | bits >>> num - cbit & (1 << cbit) - 1;
            this.bitCount += cbit;
            num -= cbit;
            if (this.bitCount != 8) continue;
            try {
                this.stream.write(this.pointer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.pointer = 0;
            this.bitCount = 0;
        }
    }

    public void writeByte(byte nextByte) {
        if (this.bitCount == 0) {
            try {
                this.stream.write(nextByte);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.writeBits(nextByte, 8);
        }
    }

    public void writeBytes(byte[] bytes) {
        if (this.bitCount == 0) {
            try {
                this.stream.write(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            for (byte b : bytes) {
                this.writeByte(b);
            }
        }
    }
}

