/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.mybatis.plugins;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class SwaggerPlugin
extends PluginAdapter {
    public boolean validate(List<String> list) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addModelClassAnnotations(topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        String remarks = introspectedColumn.getRemarks();
        this.genFieldAnnotation(field, remarks, introspectedColumn);
        return true;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        this.addMapperInterfaceAnnotations(interfaze);
        return true;
    }

    private void addModelClassAnnotations(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addImportedType("io.swagger.annotations.ApiModel");
        topLevelClass.addImportedType("io.swagger.annotations.ApiModelProperty");
        topLevelClass.addAnnotation("@ApiModel");
    }

    private void addMapperInterfaceAnnotations(Interface interfaze) {
        interfaze.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Repository"));
        interfaze.addAnnotation("@Repository");
    }

    private void genFieldAnnotation(Field field, String remarks, IntrospectedColumn introspectedColumn) {
        remarks = remarks.replace("\"", "\\\"");
        field.addAnnotation("@ApiModelProperty(value = \"" + remarks + "\")");
    }
}

