/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.mybatis.plugins;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class CommentPlugin
extends PluginAdapter {
    public boolean validate(List<String> list) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.genJavaTypeComment((JavaElement)topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        String remarks = introspectedColumn.getRemarks();
        this.genFieldComment(field, remarks);
        return true;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        this.genJavaTypeComment((JavaElement)interfaze, introspectedTable);
        return true;
    }

    private void genFieldComment(Field field, String remarks) {
        field.addJavaDocLine("/**");
        if (StringUtility.stringHasValue((String)remarks)) {
            String[] remarkLines;
            for (String remarkLine : remarkLines = remarks.split(System.getProperty("line.separator"))) {
                field.addJavaDocLine(" * " + remarkLine);
            }
        }
        field.addJavaDocLine(" */");
    }

    private void genJavaTypeComment(JavaElement javaElement, IntrospectedTable introspectedTable) {
        String remarks = introspectedTable.getRemarks();
        javaElement.addJavaDocLine("/**");
        if (StringUtility.stringHasValue((String)remarks)) {
            String[] remarkLines;
            for (String remarkLine : remarkLines = remarks.split(System.getProperty("line.separator"))) {
                javaElement.addJavaDocLine(" * " + remarkLine);
            }
        }
        javaElement.addJavaDocLine(" * ");
        javaElement.addJavaDocLine(" * " + introspectedTable.getFullyQualifiedTable());
        javaElement.addJavaDocLine(this.genAuthorComment());
        javaElement.addJavaDocLine(this.genDateComment());
        javaElement.addJavaDocLine(" */");
    }

    private String genAuthorComment() {
        return " * @author " + System.getProperties().getProperty("user.name");
    }

    private String genDateComment() {
        return " * @date " + this.getDateString();
    }

    protected String getDateString() {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
    }
}

