package net.ifok.mybatis.plugins;

import static net.ifok.mybatis.util.PluginUtils.*;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.internal.util.JavaBeansUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 * @Description:  insert 返回主键给实体类
 * @Author: leftso
 * @Date: 2020/12/2 15:35
 * @version mybatis-generator-maven-plugin:1.4.0
 **/
public class PrimaryKeyPlugin extends PluginAdapter {
    @Override
    public boolean validate(List<String> list) {
        return true;
    }

    /**
     * 单个记录insert 添加返回id主键
     * @param method
     * @param interfaze
     * @param introspectedTable
     * @return
     */
    @Override
    public boolean clientBasicInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Options"));
        IntrospectedColumn autoIncrementPrimaryKeyColumn = getAutoIncrementPrimaryKeyColumn(introspectedTable);
        if (Objects.nonNull(autoIncrementPrimaryKeyColumn)){
            String actualColumnName = autoIncrementPrimaryKeyColumn.getActualColumnName();
            String camelizeName = JavaBeansUtil.getCamelCaseString(actualColumnName,false);
            method.addAnnotation("@Options(useGeneratedKeys = true,keyProperty = \"record."+camelizeName+"\"," +
                    "keyColumn = \""+actualColumnName+"\")");
        }
        return true;
    }

    /**
     * Mapper接口 扩展
     *
     * @author leftso
     */
    @Override
    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {

        IntrospectedColumn autoIncrementPrimaryKeyColumn = getAutoIncrementPrimaryKeyColumn(introspectedTable);
        if (Objects.isNull(autoIncrementPrimaryKeyColumn)){
            return true;
        }


        String actualColumnName = autoIncrementPrimaryKeyColumn.getActualColumnName();
        String camelizeName = JavaBeansUtil.getCamelCaseString(actualColumnName,false);

        //imports
        interfazeImports(interfaze);

        //1-1
        addMethodInsertMultipleWithGeneratedKeys(interfaze,introspectedTable,camelizeName);
        //1-2
        addMethodInsertMultipleWithGeneratedKeysDefault(interfaze,introspectedTable);
        //1-3
        insertMultipleWithGeneratedKeys(interfaze,introspectedTable);

        return true;
    }

    /**
     * 添加依赖import
     * @param interfaze
     */
    public void interfazeImports(Interface interfaze){
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Insert"));
        interfaze.addImportedType(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Param"));
    }

    /**
     *  return ids - 1
     * @param interfaze
     * @param introspectedTable
     */
    public void addMethodInsertMultipleWithGeneratedKeys(Interface interfaze, IntrospectedTable introspectedTable,String primaryKey){
        Method insertMultipleWithGeneratedKeys=new Method("insertMultipleWithGeneratedKeys");
        insertMultipleWithGeneratedKeys.addAnnotation("@Generated(\"org.mybatis.generator.api.MyBatisGenerator\")");
        insertMultipleWithGeneratedKeys.addAnnotation("@Options(useGeneratedKeys=true, keyProperty=\"records."+primaryKey+"\")");
        insertMultipleWithGeneratedKeys.addAnnotation("@Insert({\"${insertStatement}\"})");

        Parameter statementParameter=new Parameter(FullyQualifiedJavaType.getStringInstance(),"statement");
        statementParameter.addAnnotation("@Param(\"insertStatement\")");
        insertMultipleWithGeneratedKeys.addParameter(statementParameter);

        FullyQualifiedJavaType newListInstance = FullyQualifiedJavaType.getNewListInstance();
        newListInstance.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        Parameter recordsParameter=new Parameter(newListInstance,"records");
        recordsParameter.addAnnotation(" @Param(\"records\")");
        insertMultipleWithGeneratedKeys.addParameter(recordsParameter);

        insertMultipleWithGeneratedKeys.setReturnType(FullyQualifiedJavaType.getIntInstance());
        insertMultipleWithGeneratedKeys.setVisibility(JavaVisibility.DEFAULT);
        insertMultipleWithGeneratedKeys.setAbstract(true);

        //add method
        interfaze.addMethod(insertMultipleWithGeneratedKeys);
    }

    /**
     * return ids - 2
     * @param interfaze
     * @param introspectedTable
     */
    public void addMethodInsertMultipleWithGeneratedKeysDefault(Interface interfaze, IntrospectedTable introspectedTable){

        Method insertMultipleWithGeneratedKeys=new Method("insertMultipleWithGeneratedKeys");
        insertMultipleWithGeneratedKeys.addAnnotation("@Generated(\"org.mybatis.generator.api.MyBatisGenerator\")");

        FullyQualifiedJavaType parameterType=new FullyQualifiedJavaType("org.mybatis.dynamic.sql.insert.render.MultiRowInsertStatementProvider");
        parameterType.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        Parameter multiInsertParameter=new Parameter(parameterType,"multiInsert");

        insertMultipleWithGeneratedKeys.addParameter(multiInsertParameter);

        insertMultipleWithGeneratedKeys.setDefault(true);
        insertMultipleWithGeneratedKeys.addBodyLine("return insertMultipleWithGeneratedKeys(multiInsert.getInsertStatement(), multiInsert.getRecords());");
        insertMultipleWithGeneratedKeys.setReturnType(FullyQualifiedJavaType.getIntInstance());

        interfaze.addMethod(insertMultipleWithGeneratedKeys);
    }

    /**
     * return ids - 3
     * @param interfaze
     * @param introspectedTable
     */
    public void insertMultipleWithGeneratedKeys(Interface interfaze, IntrospectedTable introspectedTable){
        Method insertMultipleWithGeneratedKeys=new Method("insertMultipleWithGeneratedKeys");
        insertMultipleWithGeneratedKeys.addAnnotation("@Generated(\"org.mybatis.generator.api.MyBatisGenerator\")");

        FullyQualifiedJavaType parameterType=new FullyQualifiedJavaType("java.util.Collection");
        parameterType.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        Parameter parameter=new Parameter(parameterType,"records");

        insertMultipleWithGeneratedKeys.addParameter(parameter);

        insertMultipleWithGeneratedKeys.setDefault(true);

        Collection<String> javaCode=new ArrayList<>();

        String fullyQualifiedTableNameAtRuntime = introspectedTable.getFullyQualifiedTableNameAtRuntime();
        String camelCaseTableName = JavaBeansUtil.getCamelCaseString(fullyQualifiedTableNameAtRuntime, false);

        javaCode.add(" return MyBatis3Utils.insertMultiple(this::insertMultipleWithGeneratedKeys, records, "+camelCaseTableName+", c ->");

        List<IntrospectedColumn> tableAllColumns = introspectedTable.getAllColumns();
        for (int i=0;i<tableAllColumns.size();i++){
            IntrospectedColumn tableAllColumn = tableAllColumns.get(i);
            String columnName=JavaBeansUtil.getCamelCaseString(tableAllColumn.getActualColumnName(),false);
            if (i==0){
                javaCode.add("                c.map("+columnName+").toProperty(\""+columnName+"\")");
            }else{
                javaCode.add("                .map("+columnName+").toProperty(\""+columnName+"\")");
            }
        }
        javaCode.add("   );");

        insertMultipleWithGeneratedKeys.addBodyLines(javaCode);

        insertMultipleWithGeneratedKeys.setReturnType(FullyQualifiedJavaType.getIntInstance());

        interfaze.addMethod(insertMultipleWithGeneratedKeys);

    }

}
