/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.limiter.interceptor;

import com.google.common.util.concurrent.RateLimiter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ifok.limiter.config.LimitProperties;
import net.ifok.limiter.exception.GlobalLimiterException;
import net.ifok.limiter.exception.SpecialLimiterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RateLimiterInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterInterceptor.class);
    LimitProperties limitProperties;
    RateLimiter globalRateLimiter = null;
    Map<String, RateLimiter> rateLimiterMap = new HashMap<String, RateLimiter>();

    public RateLimiterInterceptor(LimitProperties limitProperties) {
        this.limitProperties = limitProperties;
        if (limitProperties.isEnabled()) {
            this.initRateLimiters();
        }
    }

    public void initRateLimiters() {
        if (Objects.nonNull(this.limitProperties.getGlobalQps()) && this.limitProperties.getGlobalQps() > 0.0) {
            this.globalRateLimiter = RateLimiter.create((double)this.limitProperties.getGlobalQps());
        } else {
            log.warn("GlobalRateLimiter not init,globalQps - [{}]", (Object)this.limitProperties.getGlobalQps());
        }
        Map<String, Double> limitMapping = this.limitProperties.getSpecialMapping();
        if (!CollectionUtils.isEmpty(limitMapping)) {
            limitMapping.forEach((k, v) -> {
                if (Objects.nonNull(v) && v > 0.0) {
                    this.rateLimiterMap.put((String)k, RateLimiter.create((double)v));
                } else {
                    log.warn("ignore limit init key-[{}],value-[{}]", k, v);
                }
            });
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String uri = request.getRequestURI();
        String ua = request.getHeader("User-Agent");
        String method = request.getMethod();
        if (this.limitProperties.isEnabled()) {
            boolean ignore = this.ignore(uri, ua);
            String special = this.special(uri);
            if (ignore) {
                if (StringUtils.isEmpty((Object)special)) {
                    return true;
                }
                if (this.limitProperties.isIgnorePriority()) {
                    return true;
                }
            }
            if (!StringUtils.isEmpty((Object)special)) {
                RateLimiter rateLimiter = this.rateLimiterMap.get(special);
                if (rateLimiter.tryAcquire()) {
                    if (Objects.isNull(this.globalRateLimiter)) {
                        return true;
                    }
                    if (this.globalRateLimiter.tryAcquire()) {
                        return true;
                    }
                    throw new GlobalLimiterException(method, uri);
                }
                throw new SpecialLimiterException(method, uri);
            }
            if (Objects.isNull(this.globalRateLimiter)) {
                return true;
            }
            if (this.globalRateLimiter.tryAcquire()) {
                return true;
            }
            throw new GlobalLimiterException(method, uri);
        }
        return true;
    }

    private String special(String uri) {
        List keys = this.rateLimiterMap.keySet().stream().filter(o -> o.contains("**")).collect(Collectors.toList());
        for (String key : keys) {
            String regex = "^" + key.replace("**", ".*") + "$";
            boolean matches = Pattern.matches(regex, uri);
            if (!matches) continue;
            return key;
        }
        List unMatchKeys = this.rateLimiterMap.keySet().stream().filter(o -> !o.contains("/**")).collect(Collectors.toList());
        for (String key : unMatchKeys) {
            if (!key.equals(uri)) continue;
            return key;
        }
        return null;
    }

    private boolean ignore(String uri, String ua) {
        boolean ignoreURL = this.ignoreURL(uri);
        if (ignoreURL) {
            return true;
        }
        return this.ignoreUA(ua);
    }

    private boolean ignoreUA(String ua) {
        List<String> ignoreUas = this.limitProperties.getIgnoreUas();
        if (CollectionUtils.isEmpty(ignoreUas) || StringUtils.isEmpty((Object)ua)) {
            return false;
        }
        ignoreUas = ignoreUas.stream().map(o -> o.toUpperCase()).collect(Collectors.toList());
        String uaUpper = ua.toUpperCase();
        return ignoreUas.stream().anyMatch(uaUpper::contains);
    }

    private boolean ignoreURL(String uri) {
        if (CollectionUtils.isEmpty(this.limitProperties.getIgnoreUrls())) {
            return false;
        }
        boolean regx = this.limitProperties.getIgnoreUrls().stream().filter(o -> o.contains("**")).map(urlP -> "^" + urlP.replace("**", ".*") + "$").anyMatch(uri::matches);
        if (!regx) {
            return this.limitProperties.getIgnoreUrls().contains(uri);
        }
        return true;
    }
}

