/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.limiter.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.limiter")
public class LimitProperties {
    boolean enabled = true;
    double globalQps = 50.0;
    Map<String, Double> specialMapping = new LinkedHashMap<String, Double>();
    List<String> ignoreUrls = new ArrayList<String>();
    List<String> ignoreUas = new ArrayList<String>();
    boolean ignorePriority = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getGlobalQps() {
        return this.globalQps;
    }

    public Map<String, Double> getSpecialMapping() {
        return this.specialMapping;
    }

    public List<String> getIgnoreUrls() {
        return this.ignoreUrls;
    }

    public List<String> getIgnoreUas() {
        return this.ignoreUas;
    }

    public boolean isIgnorePriority() {
        return this.ignorePriority;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setGlobalQps(double globalQps) {
        this.globalQps = globalQps;
    }

    public void setSpecialMapping(Map<String, Double> specialMapping) {
        this.specialMapping = specialMapping;
    }

    public void setIgnoreUrls(List<String> ignoreUrls) {
        this.ignoreUrls = ignoreUrls;
    }

    public void setIgnoreUas(List<String> ignoreUas) {
        this.ignoreUas = ignoreUas;
    }

    public void setIgnorePriority(boolean ignorePriority) {
        this.ignorePriority = ignorePriority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimitProperties)) {
            return false;
        }
        LimitProperties other = (LimitProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (Double.compare(this.getGlobalQps(), other.getGlobalQps()) != 0) {
            return false;
        }
        Map<String, Double> this$specialMapping = this.getSpecialMapping();
        Map<String, Double> other$specialMapping = other.getSpecialMapping();
        if (this$specialMapping == null ? other$specialMapping != null : !((Object)this$specialMapping).equals(other$specialMapping)) {
            return false;
        }
        List<String> this$ignoreUrls = this.getIgnoreUrls();
        List<String> other$ignoreUrls = other.getIgnoreUrls();
        if (this$ignoreUrls == null ? other$ignoreUrls != null : !((Object)this$ignoreUrls).equals(other$ignoreUrls)) {
            return false;
        }
        List<String> this$ignoreUas = this.getIgnoreUas();
        List<String> other$ignoreUas = other.getIgnoreUas();
        if (this$ignoreUas == null ? other$ignoreUas != null : !((Object)this$ignoreUas).equals(other$ignoreUas)) {
            return false;
        }
        return this.isIgnorePriority() == other.isIgnorePriority();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LimitProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $globalQps = Double.doubleToLongBits(this.getGlobalQps());
        result = result * 59 + (int)($globalQps >>> 32 ^ $globalQps);
        Map<String, Double> $specialMapping = this.getSpecialMapping();
        result = result * 59 + ($specialMapping == null ? 43 : ((Object)$specialMapping).hashCode());
        List<String> $ignoreUrls = this.getIgnoreUrls();
        result = result * 59 + ($ignoreUrls == null ? 43 : ((Object)$ignoreUrls).hashCode());
        List<String> $ignoreUas = this.getIgnoreUas();
        result = result * 59 + ($ignoreUas == null ? 43 : ((Object)$ignoreUas).hashCode());
        result = result * 59 + (this.isIgnorePriority() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "LimitProperties(enabled=" + this.isEnabled() + ", globalQps=" + this.getGlobalQps() + ", specialMapping=" + this.getSpecialMapping() + ", ignoreUrls=" + this.getIgnoreUrls() + ", ignoreUas=" + this.getIgnoreUas() + ", ignorePriority=" + this.isIgnorePriority() + ")";
    }
}

