package net.ifok.limiter.exception;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description:  限流异常
 * @Author: xq 
 * @Date: 2021/9/28 10:59
 **/
@NoArgsConstructor
@Data
public class LimiterException extends RuntimeException {
    String method;
    String url;

    public LimiterException(String method, String url) {
        super("method:"+method+" url:"+url);
        this.method = method;
        this.url = url;
    }
}
