package net.ifok.limiter.config;

import net.ifok.limiter.interceptor.RateLimiterInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;

@Configuration
public class LimitConfig implements WebMvcConfigurer {
    @Resource
    LimitProperties limitProperties;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        if (limitProperties.enabled){
            registry.addInterceptor(
                    new RateLimiterInterceptor(limitProperties)
            ).addPathPatterns("/**");
        }
    }
}
