/*
 * Copyright 2019-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.ifok.limiter;

import lombok.extern.slf4j.Slf4j;
import net.ifok.limiter.config.LimitConfig;
import net.ifok.limiter.config.LimitProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * @Description:  自动加载
 * @Author: leftso
 * @Date: 2020/11/26 13:29
 **/
@Slf4j
@Configuration
@Import({LimitProperties.class, LimitConfig.class})
public class LimiterAutoConfig {

    public LimiterAutoConfig(){
        log.info("Init LimiterAutoConfig ...");
    }
}
