/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.png.compress;

public class Quant32 {
    private static final int IndexBits = 6;
    private static final int IndexBitsPlus = 7;
    private static final int DoubleIndexBits = 12;
    private static final int IndexAlphaBits = 3;
    private static final int SumBits = 9;
    private static final int IndexCount = 65;
    private static final int IndexAlphaCount = 9;
    private static final int TableLength = 2471625;
    private final long[] vwt = new long[2471625];
    private final long[] vmr = new long[2471625];
    private final long[] vmg = new long[2471625];
    private final long[] vmb = new long[2471625];
    private final long[] vma = new long[2471625];
    private final double[] m2 = new double[2471625];

    private static int indexify(int r, int g, int b, int a) {
        return (r << 15) + (r << 10) + (g << 9) + (r << 12) + (r << 7) + (g << 6) + (r + g + b << 3) + r + g + b + a;
    }

    private static double volume(Cube cube, long[] moment) {
        return moment[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
    }

    private static long base(Cube cube, int direction, long[] moment) {
        switch (direction) {
            case 3: {
                return -moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 2: {
                return -moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 1: {
                return -moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
            case 0: {
                return -moment[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
            }
        }
        return 0L;
    }

    private static long findTop(Cube cube, int direction, int position, long[] moment) {
        switch (direction) {
            case 3: {
                return moment[Quant32.indexify(position, cube.G1, cube.B1, cube.A1)] - moment[Quant32.indexify(position, cube.G1, cube.B1, cube.A0)] - moment[Quant32.indexify(position, cube.G1, cube.B0, cube.A1)] + moment[Quant32.indexify(position, cube.G1, cube.B0, cube.A0)] - moment[Quant32.indexify(position, cube.G0, cube.B1, cube.A1)] + moment[Quant32.indexify(position, cube.G0, cube.B1, cube.A0)] + moment[Quant32.indexify(position, cube.G0, cube.B0, cube.A1)] - moment[Quant32.indexify(position, cube.G0, cube.B0, cube.A0)];
            }
            case 2: {
                return moment[Quant32.indexify(cube.R1, position, cube.B1, cube.A1)] - moment[Quant32.indexify(cube.R1, position, cube.B1, cube.A0)] - moment[Quant32.indexify(cube.R1, position, cube.B0, cube.A1)] + moment[Quant32.indexify(cube.R1, position, cube.B0, cube.A0)] - moment[Quant32.indexify(cube.R0, position, cube.B1, cube.A1)] + moment[Quant32.indexify(cube.R0, position, cube.B1, cube.A0)] + moment[Quant32.indexify(cube.R0, position, cube.B0, cube.A1)] - moment[Quant32.indexify(cube.R0, position, cube.B0, cube.A0)];
            }
            case 1: {
                return moment[Quant32.indexify(cube.R1, cube.G1, position, cube.A1)] - moment[Quant32.indexify(cube.R1, cube.G1, position, cube.A0)] - moment[Quant32.indexify(cube.R1, cube.G0, position, cube.A1)] + moment[Quant32.indexify(cube.R1, cube.G0, position, cube.A0)] - moment[Quant32.indexify(cube.R0, cube.G1, position, cube.A1)] + moment[Quant32.indexify(cube.R0, cube.G1, position, cube.A0)] + moment[Quant32.indexify(cube.R0, cube.G0, position, cube.A1)] - moment[Quant32.indexify(cube.R0, cube.G0, position, cube.A0)];
            }
            case 0: {
                return moment[Quant32.indexify(cube.R1, cube.G1, cube.B1, position)] - moment[Quant32.indexify(cube.R1, cube.G1, cube.B0, position)] - moment[Quant32.indexify(cube.R1, cube.G0, cube.B1, position)] + moment[Quant32.indexify(cube.R1, cube.G0, cube.B0, position)] - moment[Quant32.indexify(cube.R0, cube.G1, cube.B1, position)] + moment[Quant32.indexify(cube.R0, cube.G1, cube.B0, position)] + moment[Quant32.indexify(cube.R0, cube.G0, cube.B1, position)] - moment[Quant32.indexify(cube.R0, cube.G0, cube.B0, position)];
            }
        }
        return 0L;
    }

    private void histogram(int[][] image) {
        int mm = 2;
        int nn = 5;
        int h = image.length;
        int w = image[0].length;
        for (int y = 0; y < h; ++y) {
            int[] temp = image[y];
            for (int x = 0; x < w; ++x) {
                int ind;
                int val = temp[x];
                int a = val >> 24 & 0xFF;
                int r = val >> 16 & 0xFF;
                int g = val >> 8 & 0xFF;
                int b = val & 0xFF;
                int inr = r >> mm;
                int ing = g >> mm;
                int inb = b >> mm;
                int ina = a >> nn;
                int n = ind = Quant32.indexify(inr + 1, ing + 1, inb + 1, ina + 1);
                this.vwt[n] = this.vwt[n] + 1L;
                int n2 = ind;
                this.vmr[n2] = this.vmr[n2] + (long)r;
                int n3 = ind;
                this.vmg[n3] = this.vmg[n3] + (long)g;
                int n4 = ind;
                this.vmb[n4] = this.vmb[n4] + (long)b;
                int n5 = ind;
                this.vma[n5] = this.vma[n5] + (long)a;
                int n6 = ind;
                this.m2[n6] = this.m2[n6] + (double)(r * r + g * g + b * b + a * a);
            }
        }
    }

    private void M3d() {
        int multiCount = 585;
        for (int r = 1; r < 65; ++r) {
            long[] volume = new long[multiCount];
            long[] volR = new long[multiCount];
            long[] volG = new long[multiCount];
            long[] volB = new long[multiCount];
            long[] volA = new long[multiCount];
            double[] volTemp = new double[multiCount];
            for (int g = 1; g < 65; ++g) {
                long[] area = new long[9];
                long[] areaR = new long[9];
                long[] areaG = new long[9];
                long[] areaB = new long[9];
                long[] areaA = new long[9];
                double[] areaTemp = new double[9];
                for (int b = 1; b < 65; ++b) {
                    long line = 0L;
                    long line_r = 0L;
                    long line_g = 0L;
                    long line_b = 0L;
                    long line_a = 0L;
                    double line2 = 0.0;
                    for (int a = 1; a < 9; ++a) {
                        int inv;
                        int ind1 = Quant32.indexify(r, g, b, a);
                        line += this.vwt[ind1];
                        line_r += this.vmr[ind1];
                        line_g += this.vmg[ind1];
                        line_b += this.vmb[ind1];
                        line_a += this.vma[ind1];
                        line2 += this.m2[ind1];
                        int n = a;
                        area[n] = area[n] + line;
                        int n2 = a;
                        areaR[n2] = areaR[n2] + line_r;
                        int n3 = a;
                        areaG[n3] = areaG[n3] + line_g;
                        int n4 = a;
                        areaB[n4] = areaB[n4] + line_b;
                        int n5 = a;
                        areaA[n5] = areaA[n5] + line_a;
                        int n6 = a;
                        areaTemp[n6] = areaTemp[n6] + line2;
                        int n7 = inv = b * 9 + a;
                        volume[n7] = volume[n7] + area[a];
                        int n8 = inv;
                        volR[n8] = volR[n8] + areaR[a];
                        int n9 = inv;
                        volG[n9] = volG[n9] + areaG[a];
                        int n10 = inv;
                        volB[n10] = volB[n10] + areaB[a];
                        int n11 = inv;
                        volA[n11] = volA[n11] + areaA[a];
                        int n12 = inv;
                        volTemp[n12] = volTemp[n12] + areaTemp[a];
                        int ind2 = ind1 - Quant32.indexify(1, 0, 0, 0);
                        this.vwt[ind1] = this.vwt[ind2] + volume[inv];
                        this.vmr[ind1] = this.vmr[ind2] + volR[inv];
                        this.vmg[ind1] = this.vmg[ind2] + volG[inv];
                        this.vmb[ind1] = this.vmb[ind2] + volB[inv];
                        this.vma[ind1] = this.vma[ind2] + volA[inv];
                        this.m2[ind1] = this.m2[ind2] + volTemp[inv];
                    }
                }
            }
        }
    }

    private double variance(Cube cube) {
        double dr = Quant32.volume(cube, this.vmr);
        double dg = Quant32.volume(cube, this.vmg);
        double db = Quant32.volume(cube, this.vmb);
        double da = Quant32.volume(cube, this.vma);
        double cc = this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A1)] - this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B1, cube.A0)] - this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A1)] + this.m2[Quant32.indexify(cube.R1, cube.G1, cube.B0, cube.A0)] - this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A1)] + this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B1, cube.A0)] + this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A1)] - this.m2[Quant32.indexify(cube.R1, cube.G0, cube.B0, cube.A0)] - this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A1)] + this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B1, cube.A0)] + this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A1)] - this.m2[Quant32.indexify(cube.R0, cube.G1, cube.B0, cube.A0)] + this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A1)] - this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B1, cube.A0)] - this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A1)] + this.m2[Quant32.indexify(cube.R0, cube.G0, cube.B0, cube.A0)];
        return cc - (dr * dr + dg * dg + db * db + da * da) / Quant32.volume(cube, this.vwt);
    }

    private Object[] maximize(Cube cube, int direction, int first, int last, double whole_r, double whole_g, double whole_b, double whole_a, double whole_w) {
        long base_r = Quant32.base(cube, direction, this.vmr);
        long base_g = Quant32.base(cube, direction, this.vmg);
        long base_b = Quant32.base(cube, direction, this.vmb);
        long base_a = Quant32.base(cube, direction, this.vma);
        long base_w = Quant32.base(cube, direction, this.vwt);
        double max = 0.0;
        int cut = -1;
        for (int i = first; i < last; ++i) {
            double half_r = base_r + Quant32.findTop(cube, direction, i, this.vmr);
            double half_g = base_g + Quant32.findTop(cube, direction, i, this.vmg);
            double half_b = base_b + Quant32.findTop(cube, direction, i, this.vmb);
            double half_a = base_a + Quant32.findTop(cube, direction, i, this.vma);
            double half_w = base_w + Quant32.findTop(cube, direction, i, this.vwt);
            if (half_w == 0.0) continue;
            double temp = (half_r * half_r + half_g * half_g + half_b * half_b + half_a * half_a) / half_w;
            half_r = whole_r - half_r;
            half_g = whole_g - half_g;
            half_b = whole_b - half_b;
            half_a = whole_a - half_a;
            if ((half_w = whole_w - half_w) == 0.0 || !((temp += (half_r * half_r + half_g * half_g + half_b * half_b + half_a * half_a) / half_w) > max)) continue;
            max = temp;
            cut = i;
        }
        return new Object[]{cut, max};
    }

    private boolean cut(Cube set1, Cube set2) {
        int dir;
        double whole_r = Quant32.volume(set1, this.vmr);
        double whole_g = Quant32.volume(set1, this.vmg);
        double whole_b = Quant32.volume(set1, this.vmb);
        double whole_a = Quant32.volume(set1, this.vma);
        double whole_w = Quant32.volume(set1, this.vwt);
        Object[] temp = this.maximize(set1, 3, set1.R0 + 1, set1.R1, whole_r, whole_g, whole_b, whole_a, whole_w);
        int cutr = (Integer)temp[0];
        double maxr = (Double)temp[1];
        temp = this.maximize(set1, 2, set1.G0 + 1, set1.G1, whole_r, whole_g, whole_b, whole_a, whole_w);
        int cutg = (Integer)temp[0];
        double maxg = (Double)temp[1];
        temp = this.maximize(set1, 1, set1.B0 + 1, set1.B1, whole_r, whole_g, whole_b, whole_a, whole_w);
        int cutb = (Integer)temp[0];
        double maxb = (Double)temp[1];
        temp = this.maximize(set1, 0, set1.A0 + 1, set1.A1, whole_r, whole_g, whole_b, whole_a, whole_w);
        int cuta = (Integer)temp[0];
        double maxa = (Double)temp[1];
        if (maxr >= maxg && maxr >= maxb && maxr >= maxa) {
            dir = 3;
            if (cutr < 0) {
                return false;
            }
        } else {
            dir = maxg >= maxr && maxg >= maxb && maxg >= maxa ? 2 : (maxb >= maxr && maxb >= maxg && maxb >= maxa ? 1 : 0);
        }
        set2.R1 = set1.R1;
        set2.G1 = set1.G1;
        set2.B1 = set1.B1;
        set2.A1 = set1.A1;
        switch (dir) {
            case 3: {
                set2.R0 = set1.R1 = cutr;
                set2.G0 = set1.G0;
                set2.B0 = set1.B0;
                set2.A0 = set1.A0;
                break;
            }
            case 2: {
                set2.G0 = set1.G1 = cutg;
                set2.R0 = set1.R0;
                set2.B0 = set1.B0;
                set2.A0 = set1.A0;
                break;
            }
            case 1: {
                set2.B0 = set1.B1 = cutb;
                set2.R0 = set1.R0;
                set2.G0 = set1.G0;
                set2.A0 = set1.A0;
                break;
            }
            case 0: {
                set2.A0 = set1.A1 = cuta;
                set2.R0 = set1.R0;
                set2.G0 = set1.G0;
                set2.B0 = set1.B0;
            }
        }
        set1.Volume = (set1.R1 - set1.R0) * (set1.G1 - set1.G0) * (set1.B1 - set1.B0) * (set1.A1 - set1.A0);
        set2.Volume = (set2.R1 - set2.R0) * (set2.G1 - set2.G0) * (set2.B1 - set2.B0) * (set2.A1 - set2.A0);
        return true;
    }

    private void buildCube(Cube[] cube, int colorCount) {
        double[] vv = new double[colorCount];
        for (int i = 0; i < colorCount; ++i) {
            cube[i] = new Cube();
        }
        cube[0].A0 = 0;
        cube[0].B0 = 0;
        cube[0].G0 = 0;
        cube[0].R0 = 0;
        cube[0].B1 = 64;
        cube[0].G1 = 64;
        cube[0].R1 = 64;
        cube[0].A1 = 8;
        int next = 0;
        for (int i = 1; i < colorCount; ++i) {
            if (this.cut(cube[next], cube[i])) {
                vv[next] = cube[next].Volume > 1 ? this.variance(cube[next]) : 0.0;
                vv[i] = cube[i].Volume > 1 ? this.variance(cube[i]) : 0.0;
            } else {
                vv[next] = 0.0;
                --i;
            }
            next = 0;
            double temp = vv[0];
            for (int k = 1; k <= i; ++k) {
                if (!(vv[k] > temp)) continue;
                temp = vv[k];
                next = k;
            }
            if (temp <= 0.0) break;
        }
    }

    public Object[] getPalette(int[][] image) {
        int colorCount = 256;
        this.histogram(image);
        this.M3d();
        Cube[] cube = new Cube[colorCount];
        this.buildCube(cube, colorCount);
        byte[] palette = new byte[768];
        byte[] trns = new byte[256];
        int z = 0;
        for (int k = 0; k < colorCount; ++k) {
            double weight = Quant32.volume(cube[k], this.vwt);
            if (weight != 0.0) {
                trns[k] = (byte)(Quant32.volume(cube[k], this.vma) / weight);
                palette[z++] = (byte)(Quant32.volume(cube[k], this.vmr) / weight);
                palette[z++] = (byte)(Quant32.volume(cube[k], this.vmg) / weight);
                palette[z++] = (byte)(Quant32.volume(cube[k], this.vmb) / weight);
                continue;
            }
            z += 4;
        }
        return new Object[]{palette, trns};
    }

    private class Cube {
        int A0;
        int A1;
        int R0;
        int R1;
        int G0;
        int G1;
        int B0;
        int B1;
        int Volume;

        private Cube() {
        }
    }
}

