package net.ifok.common.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamUtils {
    private StreamUtils(){}
    /***
     * 获取系统文本换行符
     */
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    /**
     * 系统文本换行符长度
     */
    public static final int LINE_SEPARATOR_LENGTH = LINE_SEPARATOR.length();

    /**
     * 将Java io中的inputstream转换为byte数组
     *
     * @param inputStream
     * @return
     * @throws IOException
     *             IO异常
     */
    public static byte[] inputStream2byte(InputStream inputStream) throws IOException {
        // 创建一个byte数组输出流
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        // 返回数据
        byte[] after = null;
        // 创建一个缓冲数组,即每次转换数
        byte[] buff = new byte[1024];

        int len;
        // 一次读取buff长度的byte
        while ((len = inputStream.read(buff)) != -1) {
            // 将读取的buff写入到ByteArrayOutputStream里面
            baos.write(buff, 0, len);
        }
        // 将读取完的所有转换为byte[]
        after = baos.toByteArray();

        // 关闭输出流
        if (baos != null) {
            baos.close();
        }
        // 返回字节流
        return after;
    }

    /**
     * 将Java io中的byte数组转换为inputstream
     *
     * @param bytes
     * @return
     */
    public static InputStream byte2InputStream(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }
}
