package net.ifok.common.io;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.imageio.ImageIO;
/**
 *
 *
 * <pre>
 * _________________________INFO_____________________________
 *  Description : [JavaIO相关工具类]
 *  Encoding    : [UTF-8]
 *  Package     : [org.xqlee.utils.io]
 *  Project     : [utils]
 *  Author      : [LXQ]
 *  CreateDate  : [2015年9月18日下午4:57:42]
 *  Updater     : []
 *  UpdateDate  : []
 *  UpdateRemark: []
 *  Company     : [Shallink Electronic Information]
 *  Version     : [v 1.0]
 * __________________________________________________________
 * </pre>
 */
public class IOUtils {
    private IOUtils(){}
    /***
     * 获取系统文本换行符
     */
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    /**
     * 系统文本换行符长度
     */
    public static final int LINE_SEPARATOR_LENGTH = LINE_SEPARATOR.length();

    /**
     * 将Java io中的inputstream转换为byte数组
     *
     * @param inputStream
     * @return
     * @throws IOException
     *             IO异常
     */
    public static byte[] inputStream2byte(InputStream inputStream) throws IOException {
        // 创建一个byte数组输出流
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        // 返回数据
        byte[] after = null;
        // 创建一个缓冲数组,即每次转换数
        byte[] buff = new byte[1024];

        int len;
        while ((len = inputStream.read(buff)) != -1) {// 一次读取buff长度的byte
            baos.write(buff, 0, len);// 将读取的buff写入到ByteArrayOutputStream里面
        }
        after = baos.toByteArray();// 将读取完的所有转换为byte[]

        // 关闭输出流
        if (baos != null) {
            baos.close();
        }
        // 返回字节流
        return after;
    }

    /**
     * 将Java io中的byte数组转换为inputstream
     *
     * @param bytes
     * @return
     */
    public static InputStream byte2InputStream(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    /**
     * 文件转换成byte数组
     *
     * @param file
     *            文件
     * @return 返回:byte数组
     * @throws IOException
     *             异常:IO异常
     */
    public static byte[] File2bytes(File file) throws IOException {
        byte[] buffer = null;
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[4096];
        int n;
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fis.close();
        bos.close();
        buffer = bos.toByteArray();
        return buffer;
    }

    /**
     * bytes数组转换为File类型
     *
     * @param buf
     *            bytes数组
     * @param file
     *            文件
     * @throws IOException
     *             异常:IO异常
     */
    public static File byte2File(byte[] buf, File file) throws IOException {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        fos = new FileOutputStream(file);
        bos = new BufferedOutputStream(fos);
        bos.write(buf);
        if (bos != null) {
            bos.close();
        }
        if (fos != null) {
            fos.close();
        }
        return file;
    }

    /**
     * 以指定字符集写入文件内容
     *
     * @param file
     *            参数:文件全路径
     * @param content
     *            参数:内容
     * @param charset
     *            参数:字符集[GBK/UTF-8/GB2312]
     * @param append
     *            是否以追加方式写入文件内容
     * @throws IOException
     *             异常:IO异常
     */
    public static void fileWriter(String file, String content, String charset, boolean append) throws IOException {

        BufferedWriter br = new BufferedWriter(
                new OutputStreamWriter(new FileOutputStream(new File(file), append), charset));
        br.write(content);
        br.close();
    }

    /**
     * 以指定字符集写入文件内容[jdk>=1.7]
     *
     * @param file
     *            参数:文件全路径
     * @param content
     *            参数:内容
     * @param charset
     *            参数:字符集[GBK/UTF-8/GB2312]
     * @param append
     *            是否以追加方式写入文件内容
     * @throws IOException
     *             异常:IO异常
     */
    public static void fileWriterJre7(String file, String content, String charset, boolean append) throws IOException {
        try (BufferedWriter br = new BufferedWriter(
                new OutputStreamWriter(new FileOutputStream(new File(file), append), charset))) {
            br.write(content);
        }
    }

    /**
     * 以指定字符集读取文本文件内容. jdk 1.7+
     *
     * @param file
     *            文件所在全路径
     * @param encoding
     *            字符串的字符集(如:UTF-8,GBK...)
     * @return 返回读取的字符串
     * @throws IOException
     *             IO异常
     */
    public static String fileReader(String file, String encoding) throws IOException {
        try (BufferedReader br=new BufferedReader(new InputStreamReader(new FileInputStream(new File(file)), encoding));){
            StringBuffer sb = new StringBuffer();
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(LINE_SEPARATOR);
            }

            if (sb.length() > LINE_SEPARATOR_LENGTH) {
                return sb.substring(0, sb.length() - LINE_SEPARATOR_LENGTH);
            } else {
                return sb.toString();
            }
        }catch (IOException e){
            throw e;
        }

    }

    /**
     * 指定字符集读取输入流中文本内容
     *
     * @param inputStream
     *            输入流
     * @param encoding
     *            流字符集
     * @return String类型
     * @throws IOException
     *             IO异常
     */
    public static String streamReader(InputStream inputStream, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, encoding));
        StringBuffer sb = new StringBuffer();
        String line;
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append(LINE_SEPARATOR);
        }
        // 关闭流
        br.close();
        if (sb.length() > LINE_SEPARATOR_LENGTH) {
            return sb.substring(0, sb.length() - LINE_SEPARATOR_LENGTH);
        } else {
            return sb.toString();
        }
    }

    /**
     * 采用java内部类将多个文件打包成一个zip包 <BR>
     * BUG:打包文件中不能含有zip文件
     *
     * @param srcFiles
     *            需要打包的源文件
     * @param targetFile
     *            打包后的目标文件
     * @param revovery
     *            如果存在是否覆盖
     * @throws IOException
     *             异常
     */
    public static void file2Zip(File[] srcFiles, File targetFile, boolean revovery) throws IOException {
        if (null == srcFiles || srcFiles.length == 0) {
            throw new IOException("No File To Compress.");
        }
        // 1.判断源文件是否存在
        File srcFile = null;
        for (int i = 0; i < srcFiles.length; i++) {
            srcFile = srcFiles[i];
            if (!srcFile.exists()) {
                throw new IOException("Source File Not Found [" + srcFile.getPath() + "]");
            }
        }
        // 2.判断目标文件是否存在
        if (targetFile.exists()) {
            if (!revovery) {
                throw new IOException("Found target ZIP File [" + targetFile.getPath() + "]");
            } else {
                targetFile.delete();
            }
        } else {
            // 判断生成文件的上级目录是否存在,如果不存在创建
            File parent = targetFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }

        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(targetFile);
            zos = new ZipOutputStream(new BufferedOutputStream(fos));
            // 创建ZIP实体,并添加压缩包
            ZipEntry zipEntry = null;
            for (int i = 0; i < srcFiles.length; i++) {
                String fileName = srcFiles[i].getName();
                zipEntry = new ZipEntry(fileName);
                zos.putNextEntry(zipEntry);
                // 读取待压缩的文件,并写进压缩包
                bis = new BufferedInputStream(new FileInputStream(srcFiles[i]));
                int len = 0;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] cache = new byte[1024 * 10];
                while ((len = bis.read(cache)) != -1) {
                    baos.write(cache, 0, len);
                }
                byte[] fileContent = baos.toByteArray();
                zos.write(fileContent);
            }
            // 关闭
            zos.close();
        } catch (IOException e) {
            throw e;
        } finally {
            if (null != bis) {
                bis.close();
            }
            if (null != fos) {
                fos.close();
            }
        }
    }

    /**
     *
     * <pre>
     * [Summary]
     * 判断给定的文件是否为图片文件
     * [Detail]
     * TODO
     * [Dependencies]
     *
     * [Author]
     *
     * </pre>
     *
     * @param file
     * @return
     */
    public static boolean isImage(File file) {
        boolean result = false;
        try {
            BufferedImage buf = ImageIO.read(file);
            if (buf == null) {
                return result;
            }
            result = true;
            return result;
        } catch (Exception e) {
            //e.printStackTrace();
            return result;
        }
    }

    public static void main(String[] agrs) {
        long start = System.currentTimeMillis();
        boolean isImage = isImage(new File("D:/1F.jpg"));
        System.out.println(isImage);
        System.out.println("耗时:" + (System.currentTimeMillis() - start));
    }
}
