/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RsaUtils {
    private static final String lineSeparator = System.getProperty("line.separator", "\n");
    private static final String KEY_ALGORITHM = "RSA";
    public static final String PUBLIC_KEY = "RSAPublicKey";
    public static final String PRIVATE_KEY = "RSAPrivateKey";

    public static Map<String, RSAKey> genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator kGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        KeyPair keyPair = kGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        System.out.println(publicKey.getAlgorithm());
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, RSAKey> keys = new HashMap<String, RSAKey>();
        keys.put(PUBLIC_KEY, publicKey);
        keys.put(PRIVATE_KEY, privateKey);
        return keys;
    }

    public static byte[] encrypt(Key key, byte[] input) throws Exception {
        if (key != null) {
            try {
                Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
                cipher.init(1, key);
                byte[] resultBytes = cipher.doFinal(input);
                return resultBytes;
            }
            catch (NoSuchAlgorithmException e) {
                throw new Exception("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5:" + e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                throw new Exception("\u52a0\u5bc6\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
            catch (InvalidKeyException e) {
                throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5:" + e.getMessage());
            }
            catch (IllegalBlockSizeException e) {
                throw new Exception("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5:" + e.getMessage());
            }
            catch (BadPaddingException e) {
                throw new Exception("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f:" + e.getMessage());
            }
        }
        throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
    }

    public static byte[] decrypt(Key key, byte[] input) throws Exception {
        if (key == null) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(2, key);
            byte[] output = cipher.doFinal(input);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5:" + e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new Exception("\u89e3\u5bc6\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5:" + e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5:" + e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new Exception("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f:" + e.getMessage());
        }
    }

    public static PrivateKey getPrivateKey(File file) throws Exception {
        String strPrivateKey = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
                sb.append(lineSeparator);
            }
            br.close();
            strPrivateKey = sb.toString().substring(0, sb.toString().length() - lineSeparator.length());
        }
        catch (IOException e) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u6d41\u8bfb\u53d6\u9519\u8bef:" + e.getMessage());
        }
        try {
            byte[] buffer = Base64.getDecoder().decode(strPrivateKey.getBytes());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("=====\u65e0\u6b64\u7b97\u6cd5=====");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("=====\u5bc6\u94a5\u975e\u6cd5=====");
        }
        catch (NullPointerException e) {
            throw new Exception("=====\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a=====");
        }
    }

    public static PrivateKey getPrivateKey(String strPrivateKey) throws Exception {
        try {
            byte[] buffer = Base64.getDecoder().decode(strPrivateKey.getBytes());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("=====\u65e0\u6b64\u7b97\u6cd5=====");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("=====\u5bc6\u94a5\u975e\u6cd5=====");
        }
        catch (NullPointerException e) {
            throw new Exception("=====\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a=====");
        }
    }

    public static PublicKey getPublicKey(File file) throws Exception {
        String strRSAPublicKey = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String readLine = null;
            StringBuilder sb = new StringBuilder();
            while ((readLine = br.readLine()) != null) {
                sb.append(readLine);
                sb.append(lineSeparator);
            }
            br.close();
            strRSAPublicKey = sb.toString().substring(0, sb.toString().length() - lineSeparator.length());
        }
        catch (IOException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u6d41\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException e) {
            throw new Exception("\u516c\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
        try {
            byte[] buffer = Base64.getDecoder().decode(strRSAPublicKey.getBytes());
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("=====\u65e0\u6b64\u7b97\u6cd5=====");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("=====\u516c\u94a5\u975e\u6cd5=====");
        }
        catch (NullPointerException e) {
            throw new Exception("=====\u516c\u94a5\u6570\u636e\u4e3a\u7a7a=====");
        }
    }

    public static PublicKey getPublicKey(String strPublicKey) throws Exception {
        try {
            byte[] buffer = Base64.getDecoder().decode(strPublicKey.getBytes());
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("=====\u65e0\u6b64\u7b97\u6cd5=====");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("=====\u516c\u94a5\u975e\u6cd5=====");
        }
        catch (NullPointerException e) {
            throw new Exception("=====\u516c\u94a5\u6570\u636e\u4e3a\u7a7a=====");
        }
    }

    public static String key2String(Key key) {
        byte[] keyBytes = key.getEncoded();
        String result = new String(Base64.getEncoder().encodeToString(keyBytes));
        return result;
    }

    public static void main(String[] args) throws Exception {
        Map<String, RSAKey> genKeyPair = RsaUtils.genKeyPair();
        String data = "ABC \u6211\u662f\u660e\u6587";
        String privateKeyString = genKeyPair.get(PRIVATE_KEY).toString();
        System.out.println("privateKeyString:" + privateKeyString);
        byte[] encrypt = RsaUtils.encrypt(RsaUtils.getPrivateKey(genKeyPair.get(PRIVATE_KEY).toString()), data.getBytes());
        byte[] decrypt = RsaUtils.decrypt(RsaUtils.getPublicKey(genKeyPair.get(PUBLIC_KEY).toString()), encrypt);
        String result = new String(decrypt);
        System.out.println(result);
    }
}

