package net.ifok.common.base;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
/**
 * @Description:  map工具
 * @Author: xq 
 * @Date: 2021/1/17 21:25
 **/
public class MapUtils {
    /**
     * 判断Map是否为空
     *
     * @param map
     *            待检测map
     * @return 检测结果
     */
    @SuppressWarnings("rawtypes")
    public static boolean isEmptyOrNull(Map map) {
        if (map == null || map.size() == 0) {
            return true;
        }
        return false;
    }

    /**
     * Map to Bean <功能简述> <功能详细描述>
     *
     * @param type
     * @param map
     * @return
     * @throws IntrospectionException
     * @throws IllegalAccessException
     * @throws InstantiationException
     * @throws InvocationTargetException
     *             [参数说明]
     *
     * @return Object [返回类型说明]
     * @exception throws
     *                [异常类型] [异常说明]
     * @see [类、类#方法、类#成员]
     */
    public static <T> T toBean(Class<T> type, Map<String, ? extends Object> map)
            throws IntrospectionException, IllegalAccessException, InstantiationException, InvocationTargetException {
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        T obj = type.newInstance();
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; i++) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (map.containsKey(propertyName)) {
                Object value = map.get(propertyName);
                Object[] args = new Object[1];
                args[0] = value;
                descriptor.getWriteMethod().invoke(obj, args);
            }
        }
        return obj;
    }

    /**
     * Bean转换为map
     *
     * @param bean
     *            待转换的bean
     * @return 返回转换的结果
     * @throws IntrospectionException
     *             异常
     * @throws IllegalAccessException
     *             异常
     * @throws InvocationTargetException
     *             异常
     */
    public static  Map<String, Object> toMap(Object bean)
            throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Map<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; i++) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (!propertyName.equals("class")) {
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean, new Object[0]);
                if (result != null) {
                    returnMap.put(propertyName, result);
                } else {
                    returnMap.put(propertyName, "");
                }
            }
        }
        return returnMap;
    }

    /**
     * 将Map对象按key:value格式打印到控制台 <功能详细描述>
     *
     * @param map
     *            map
     */
    @SuppressWarnings("unchecked")
    public static void printMap(Map<?, ?> map) {
        Set<?> set = map.entrySet();
        for (Iterator<Map.Entry<String, Object>> it = (Iterator<Entry<String, Object>>) set.iterator(); it.hasNext();) {
            Map.Entry<String, Object> entry = it.next();
//            logger.info(entry.getKey() + ":" + entry.getValue());
        }

    }
}
