/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;

public class ImageCompressUtils {
    public static void compress(InputStream src, OutputStream target, float quality) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).scale(1.0).outputQuality(quality).toOutputStream(target);
    }

    public static void compress(InputStream src, OutputStream target, float quality, String format) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).scale(1.0).outputFormat(format).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndReSize(InputStream src, OutputStream target, float quality, int width, int height) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).size(width, height).keepAspectRatio(false).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndReSize(InputStream src, OutputStream target, float quality, int width, int height, String format) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).size(width, height).keepAspectRatio(false).outputFormat(format).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndSizeWidth(InputStream src, OutputStream target, float quality, int width) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).width(width).keepAspectRatio(true).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndSizeWidth(InputStream src, OutputStream target, float quality, int width, String format) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).width(width).keepAspectRatio(true).outputFormat(format).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndSizeHeight(InputStream src, OutputStream target, float quality, int height) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).height(height).keepAspectRatio(true).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndSizeHeight(InputStream src, OutputStream target, float quality, int height, String format) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).height(height).keepAspectRatio(true).outputFormat(format).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndWatermark(InputStream src, OutputStream target, InputStream mark, Positions position, float opacity, float quality) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).scale(1.0).watermark((Position)position, ImageIO.read(mark), opacity).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndWatermark(InputStream src, OutputStream target, InputStream mark, Positions position, float opacity, float quality, String format) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).scale(1.0).watermark((Position)position, ImageIO.read(mark), opacity).outputFormat(format).outputQuality(quality).toOutputStream(target);
    }

    public static void compressAndWatermarks(InputStream src, OutputStream target, InputStream mark, List<Positions> positions, float opacity, float quality, String format) throws IOException {
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{src}).scale(1.0);
        BufferedImage ico = ImageIO.read(mark);
        for (Positions p : positions) {
            builder = builder.watermark((Position)p, ico, opacity);
        }
        builder.outputFormat(format).outputQuality(quality).toOutputStream(target);
    }
}

