/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.html;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ifok.common.html.model.HtmlExtractData;

public class HtmlUtils {
    private static final Pattern HTML_IMG_SRC_PATTERN = Pattern.compile("src\\s*=\\s*\"?(.*?)(\"|>|\\s+)");

    public static String[] getImageSrc(String content) {
        String img = "";
        String str = "";
        String[] images = null;
        String regEx_img = "(<img.*src\\s*=\\s*(.*?)[^>]*?>)";
        Pattern p_image = Pattern.compile(regEx_img, 2);
        Matcher m_image = p_image.matcher(content);
        while (m_image.find()) {
            img = m_image.group();
            Matcher m = HTML_IMG_SRC_PATTERN.matcher(img);
            while (m.find()) {
                String tempSelected = m.group(1);
                if ("".equals(str)) {
                    str = tempSelected;
                    continue;
                }
                String temp = tempSelected;
                str = str + "," + temp;
            }
        }
        if (!"".equals(str)) {
            images = str.split(",");
        }
        return images;
    }

    public static String createOrUpdateHtmlTagAttr(String htmlStr, String htmlTag, String attrName, String startStr) {
        String regxpForTag = "<\\s*" + htmlTag + "\\s+([^>]*)\\s*>";
        String regxpForTagAttrib = attrName + "\\s*=\\s*[\"|']([^\"|']+)[\"|']";
        Pattern patternForTag = Pattern.compile(regxpForTag);
        Pattern patternForAttrib = Pattern.compile(regxpForTagAttrib);
        Matcher matcherForTag = patternForTag.matcher(htmlStr);
        StringBuffer sb = new StringBuffer();
        boolean result = matcherForTag.find();
        while (result) {
            StringBuffer sbreplace = new StringBuffer("<" + htmlTag + " ");
            Matcher matcherForAttrib = patternForAttrib.matcher(matcherForTag.group(1));
            if (matcherForAttrib.find()) {
                matcherForAttrib.appendReplacement(sbreplace, attrName + "=\"" + startStr + "\"");
            } else {
                sbreplace.append(attrName).append("=\"").append(startStr).append("\" ");
            }
            matcherForAttrib.appendTail(sbreplace);
            matcherForTag.appendReplacement(sb, sbreplace.toString() + ">");
            result = matcherForTag.find();
        }
        matcherForTag.appendTail(sb);
        return sb.toString();
    }

    public static HtmlExtractData extractCSS(String html) {
        String regForTag = "<([^>]*style\\s*=\\s*[\"|'][^>]*[\"|'][^>]*)>";
        String regForStyle = "style\\s*=\\s*[\"|'](([^('|\")])*)[\"|']";
        Pattern patternForTag = Pattern.compile(regForTag);
        Matcher matcherForTag = patternForTag.matcher(html);
        Pattern patternForStyle = Pattern.compile(regForStyle);
        boolean result = matcherForTag.find();
        StringBuffer sb = new StringBuffer();
        StringBuffer cssSb = new StringBuffer();
        int cssCount = 0;
        while (result) {
            StringBuffer rps = new StringBuffer();
            Matcher matcher = patternForStyle.matcher(matcherForTag.group());
            if (matcher.find()) {
                String cssClassName = "auto-css-" + cssCount;
                matcher.appendReplacement(rps, "class='" + cssClassName + "'");
                matcher.appendTail(rps);
                cssSb.append(".").append(cssClassName).append("{");
                cssSb.append(matcher.group(1)).append("}").append("\r\n");
                ++cssCount;
            }
            matcherForTag.appendReplacement(sb, rps.toString());
            result = matcherForTag.find();
        }
        matcherForTag.appendTail(sb);
        HtmlExtractData data = new HtmlExtractData();
        data.setCssCodes(cssSb.toString());
        data.setHtmlCodes(sb.toString());
        return data;
    }
}

