/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.io;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;

public class IOUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int LINE_SEPARATOR_LENGTH = LINE_SEPARATOR.length();

    private IOUtils() {
    }

    public static byte[] inputStream2byte(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] after = null;
        byte[] buff = new byte[1024];
        while ((len = inputStream.read(buff)) != -1) {
            baos.write(buff, 0, len);
        }
        after = baos.toByteArray();
        if (baos != null) {
            baos.close();
        }
        return after;
    }

    public static InputStream byte2InputStream(byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    public static byte[] File2bytes(File file) throws IOException {
        int n;
        byte[] buffer = null;
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[4096];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fis.close();
        bos.close();
        buffer = bos.toByteArray();
        return buffer;
    }

    public static File byte2File(byte[] buf, File file) throws IOException {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        fos = new FileOutputStream(file);
        bos = new BufferedOutputStream(fos);
        bos.write(buf);
        if (bos != null) {
            bos.close();
        }
        if (fos != null) {
            fos.close();
        }
        return file;
    }

    public static void fileWriter(String file, String content, String charset, boolean append) throws IOException {
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(file), append), charset));
        br.write(content);
        br.close();
    }

    public static void fileWriterJre7(String file, String content, String charset, boolean append) throws IOException {
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(file), append), charset));){
            br.write(content);
        }
    }

    public static String fileReader(String file, String encoding) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(file)), encoding));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append(LINE_SEPARATOR);
        }
        br.close();
        if (sb.length() > LINE_SEPARATOR_LENGTH) {
            return sb.substring(0, sb.length() - LINE_SEPARATOR_LENGTH);
        }
        return sb.toString();
    }

    public static String streamReader(InputStream inputStream, String encoding) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, encoding));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append(LINE_SEPARATOR);
        }
        br.close();
        if (sb.length() > LINE_SEPARATOR_LENGTH) {
            return sb.substring(0, sb.length() - LINE_SEPARATOR_LENGTH);
        }
        return sb.toString();
    }

    public static void file2Zip(File[] srcFiles, File targetFile, boolean revovery) throws IOException {
        if (null == srcFiles || srcFiles.length == 0) {
            throw new IOException("No File To Compress.");
        }
        File srcFile = null;
        for (int i = 0; i < srcFiles.length; ++i) {
            srcFile = srcFiles[i];
            if (srcFile.exists()) continue;
            throw new IOException("Source File Not Found [" + srcFile.getPath() + "]");
        }
        if (targetFile.exists()) {
            if (!revovery) {
                throw new IOException("Found target ZIP File [" + targetFile.getPath() + "]");
            }
            targetFile.delete();
        } else {
            File parent = targetFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(targetFile);
            zos = new ZipOutputStream(new BufferedOutputStream(fos));
            ZipEntry zipEntry = null;
            for (int i = 0; i < srcFiles.length; ++i) {
                String fileName = srcFiles[i].getName();
                zipEntry = new ZipEntry(fileName);
                zos.putNextEntry(zipEntry);
                bis = new BufferedInputStream(new FileInputStream(srcFiles[i]));
                int len = 0;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] cache = new byte[10240];
                while ((len = bis.read(cache)) != -1) {
                    baos.write(cache, 0, len);
                }
                byte[] fileContent = baos.toByteArray();
                zos.write(fileContent);
            }
            zos.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (null != bis) {
                bis.close();
            }
            if (null != fos) {
                fos.close();
            }
        }
    }

    public static boolean isImage(File file) {
        boolean result = false;
        try {
            BufferedImage buf = ImageIO.read(file);
            if (buf == null) {
                return result;
            }
            result = true;
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    public static void main(String[] agrs) {
        long start = System.currentTimeMillis();
        boolean isImage = IOUtils.isImage(new File("D:/1F.jpg"));
        System.out.println(isImage);
        System.out.println("\u8017\u65f6:" + (System.currentTimeMillis() - start));
    }
}

