/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BytesUtils {
    public static byte[] fillCode(byte[] bin) throws IOException {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        int n = (bin.length + 10) % 8;
        if (n != 0) {
            n = 8 - n;
        }
        int r = 0;
        for (int i = 0; i < bin.length; ++i) {
            r = (r + (bin[i] & 0xFF)) % 256;
        }
        int first = r & 0xF8 | n;
        arrayOutputStream.write(first);
        arrayOutputStream.write(r);
        arrayOutputStream.write(bin);
        for (int i = 0; i < n; ++i) {
            arrayOutputStream.write(r);
        }
        byte[] result = arrayOutputStream.toByteArray();
        arrayOutputStream.close();
        return result;
    }

    public static byte[] unFillCode(byte[] bin) throws IOException {
        ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(bin);
        int first = arrayInputStream.read();
        int r = arrayInputStream.read();
        int n = r & 0xF8 ^ first;
        if (n < 0 || n > 14 || arrayInputStream.available() < n) {
            return null;
        }
        byte[] result = new byte[arrayInputStream.available() - n];
        arrayInputStream.read(result);
        arrayInputStream.close();
        int d = 0;
        for (int i = 0; i < result.length; ++i) {
            d = (d + (result[i] & 0xFF)) % 256;
        }
        return (byte[])(d == r ? result : null);
    }

    public static int findLast(byte[] bin, byte[] queryBin) {
        int total = bin.length - queryBin.length + 1;
        for (int i = 0; i < total; ++i) {
            int lastIndex = total - i - 1;
            byte[] target = BytesUtils.subBytes(bin, lastIndex, queryBin.length + lastIndex);
            if (!BytesUtils.isEquery(target, queryBin)) continue;
            return lastIndex;
        }
        return -1;
    }

    public static int find(byte[] bin, byte[] queryBin) {
        for (int i = 0; i < bin.length - queryBin.length + 1; ++i) {
            byte[] target = BytesUtils.subBytes(bin, i, queryBin.length + i);
            if (!BytesUtils.isEquery(target, queryBin)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isEquery(byte[] bin1, byte[] bin2) {
        for (int i = 0; i < bin1.length; ++i) {
            if (bin1[i] == bin2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] subBytes(byte[] bin, int start, int end) {
        if (start == 0 && end == bin.length) {
            return bin;
        }
        byte[] result = new byte[end - start];
        System.arraycopy(bin, start, result, 0, result.length);
        return result;
    }

    public static long binToLong(byte[] b) {
        long l = 0L;
        for (int i = 0; i < b.length; ++i) {
            long j_tmp = 1L;
            for (int j = 0; j < b.length - i - 1; ++j) {
                j_tmp <<= 8;
            }
            l += j_tmp * (long)(b[i] & 0xFF);
        }
        return l;
    }

    public static int binToInt(byte[] b) {
        return (int)BytesUtils.binToLong(b);
    }

    public static short binToShort(byte[] b) {
        return (short)BytesUtils.binToLong(b);
    }

    public static byte[] longToBin(long l, int size) throws IOException {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(l >> (size - 1 - i << 3) & 0xFFL);
        }
        return result;
    }

    public static byte[] intToBin(int i, int size) throws IOException {
        return BytesUtils.longToBin(i, size);
    }

    public static byte[] shortToBin(short i, int size) throws IOException {
        return BytesUtils.longToBin(i, size);
    }

    public static String binToHex(byte[] bin) {
        return BytesUtils.binToHex(bin, false);
    }

    public static String binToHex(byte[] bin, boolean format) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int n : bin) {
            int i = n;
            if (i < 0) {
                i += 256;
            }
            String hex = Integer.toHexString(i);
            while (hex.length() < 2) {
                hex = "0" + hex;
            }
            stringBuffer.append(hex);
            if (!format) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static byte[] hexToBin(String hex) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }
        for (int i = 0; i < hex.length() / 2; ++i) {
            int point = i * 2;
            byteArrayOutputStream.write(Integer.parseInt(hex.substring(point, point + 2), 16));
        }
        byteArrayOutputStream.flush();
        byte[] bin = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return bin;
    }

    public static byte[] merge(byte[] bin1, byte[] ... bins) throws IOException {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        arrayOutputStream.write(bin1);
        for (byte[] bin : bins) {
            arrayOutputStream.write(bin);
        }
        arrayOutputStream.flush();
        byte[] bin = arrayOutputStream.toByteArray();
        arrayOutputStream.close();
        return bin;
    }

    public static byte[] objectToBytes(Object object) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(object);
        oos.flush();
        byte[] bin = out.toByteArray();
        oos.close();
        out.close();
        return bin;
    }

    public static <T> T bytesToObject(byte[] buffer) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        ObjectInputStream inputStream = new ObjectInputStream(in);
        Object o = inputStream.readObject();
        inputStream.close();
        in.close();
        return (T)o;
    }
}

