/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class DateUtils {
    public static String parseDate2String(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String rdate = sdf.format(date);
        return rdate;
    }

    public static Date parseString2Date(String dateStr, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date date = null;
        date = df.parse(dateStr);
        return date;
    }

    public static String getCurrentDate(String format) {
        SimpleDateFormat sd = new SimpleDateFormat(format);
        String date = sd.format(new Date());
        return date;
    }

    public static String parseStringDateFormat(String date, String srcFormat, String destFormat) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(srcFormat);
        SimpleDateFormat dd = new SimpleDateFormat(destFormat);
        Date da = df.parse(date);
        return dd.format(da);
    }

    public static String getBeforeOrAfterNumberDateFromInputDate(String dateStr, String inputFormat, String outputFormat, int n) throws ParseException {
        Calendar c = Calendar.getInstance();
        Date date = null;
        date = new SimpleDateFormat(inputFormat).parse(dateStr);
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + n);
        String dateStrReturn = new SimpleDateFormat(outputFormat).format(c.getTime());
        return dateStrReturn;
    }

    public static String getSecondsToHHMMSS(int second) {
        int hh = 0;
        int mm = 0;
        int ss = 0;
        int temp = second % 3600;
        if (second >= 3600) {
            hh = second / 3600;
            if (temp != 0) {
                if (temp > 60) {
                    mm = temp / 60;
                    if (temp % 60 != 0) {
                        ss = temp % 60;
                    }
                } else {
                    ss = temp;
                }
            }
        } else {
            mm = second / 60;
            if (second % 60 != 0) {
                ss = second % 60;
            }
        }
        String ft = "";
        ft = hh < 10 ? ft + "0" + hh + ":" : ft + hh + ":";
        ft = mm < 10 ? ft + "0" + mm + ":" : ft + mm + ":";
        ft = ss < 10 ? ft + "0" + ss : ft + ss;
        return ft;
    }

    public static boolean isTimeHour(String h) {
        return Integer.parseInt(h) >= 0 && Integer.parseInt(h) <= 23;
    }

    public static boolean isTimeMinute(String m) {
        return Integer.parseInt(m) >= 0 && Integer.parseInt(m) <= 59;
    }

    public static boolean isTimeSecond(String s) {
        return Integer.parseInt(s) >= 0 && Integer.parseInt(s) <= 59;
    }

    public static long getMillisecondNow() {
        Date d = new Date();
        long s = d.getTime();
        d = null;
        return s;
    }

    public static long getAge(String bothday, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long SSS = System.currentTimeMillis() - sdf.parse(bothday).getTime();
        long age = SSS / 1000L / 60L / 60L / 24L / 365L;
        return age;
    }

    public static Date getDateStart(Date start) {
        if (Objects.isNull(start)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDateEnd(Date end) {
        if (Objects.isNull(end)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(end);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }
}

