/*
 * Decompiled with CFR 0.152.
 */
package net.ifok.common.base;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapUtils {
    public static boolean isEmptyOrNull(Map map) {
        return map == null || map.size() == 0;
    }

    public static final Object toBean(Class<?> type, Map<String, ? extends Object> map) throws IntrospectionException, IllegalAccessException, InstantiationException, InvocationTargetException {
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        Object obj = type.newInstance();
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (!map.containsKey(propertyName)) continue;
            Object value = map.get(propertyName);
            Object[] args = new Object[]{value};
            descriptor.getWriteMethod().invoke(obj, args);
        }
        return obj;
    }

    public static final Map<String, Object> toMap(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(bean, new Object[0]);
            if (result != null) {
                returnMap.put(propertyName, result);
                continue;
            }
            returnMap.put(propertyName, "");
        }
        return returnMap;
    }

    public static void printMap(Map<?, ?> map) {
        Set<Map.Entry<?, ?>> set = map.entrySet();
        for (Map.Entry<?, ?> entry : set) {
        }
    }
}

