package net.ifok.common.date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * @Description:  日期工具
 * @Author: xq 
 * @Date: 2021/1/17 21:17
 **/
public class DateUtils {

    /**
     * 将一个date类型日期转换为指定格式的字符串日期
     *
     * @param date
     *            源日期
     * @param format
     *            格式
     * @return 返回字符串日期或时间
     */
    public static String parseDate2String(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String rdate = sdf.format(date);
        return rdate;
    }

    /****
     * 转换字符串日期为java Date对象日期
     *
     * @param dateStr
     *            字符串日期
     * @param format
     *            格式 如：yyyy-MM-dd HH:mm:ss
     * @return
     * @throws ParseException
     */
    public static Date parseString2Date(String dateStr, String format)
            throws ParseException {
        DateFormat df = new SimpleDateFormat(format);
        Date date = null;
        date = df.parse(dateStr);
        return date;
    }

    /**
     * 获取当前系统时间或日期(任意格式)
     *
     * @param format
     *            想要获取到的日期或时间格式
     * @return 返回字符串类型日期或时间
     */
    public static String getCurrentDate(String format) {
        SimpleDateFormat sd = new SimpleDateFormat(format);
        String date = sd.format(new Date());
        return date;
    }

    /**
     * 字符串字符串日期格式转换
     *
     * @param date
     *            源字符串日期
     * @param srcFormat
     *            源字符串日期格式
     * @param destFormat
     *            输出字符串日期格式
     * @return 返回转换后的字符串日期格式
     * @throws ParseException
     *             转换异常
     */
    public static String parseStringDateFormat(String date, String srcFormat,
                                               String destFormat) throws ParseException {
        DateFormat df = new SimpleDateFormat(srcFormat);
        DateFormat dd = new SimpleDateFormat(destFormat);
        Date da;
        da = df.parse(date);
        return dd.format(da);

    }

    /**
     * 获取当前日期的前/后n天的日期字符串; n为负数，则表示前n天,正数后n天
     *
     * @param dateStr
     *            输入指定日期
     * @param inputFormat
     *            输入日期格式
     * @param outputFormat
     *            输出日期格式
     * @param n
     *            天数
     * @return 返回值
     * @throws ParseException
     *             转换异常
     */
    public static String getBeforeOrAfterNumberDateFromInputDate(
            String dateStr, String inputFormat, String outputFormat, int n)
            throws ParseException {
        Calendar c = Calendar.getInstance();
        Date date = null;
        date = new SimpleDateFormat(inputFormat).parse(dateStr);
        c.setTime(date);
        int day = c.get(Calendar.DATE);
        c.set(Calendar.DATE, day + n);
        String dateStrReturn = new SimpleDateFormat(outputFormat).format(c
                .getTime());
        return dateStrReturn;

    }

    /**
     * 整数的秒转换为:HH：MM：SS格式时间
     *
     * @param second
     *            输入参数，秒钟<br>
     *            类型：int
     * @return 时间文本<br>
     *         格式：hh:MM:ss<br>
     *         类型：java.lang.String
     */
    public static String getSecondsToHHMMSS(int second) {
        int hh = 0;
        int mm = 0;
        int ss = 0;
        int temp = second % 3600;
        if (second >= 3600) {
            hh = second / 3600;
            if (temp != 0) {
                if (temp > 60) {
                    mm = temp / 60;
                    if (temp % 60 != 0) {
                        ss = temp % 60;
                    }
                } else {
                    ss = temp;
                }
            }
        } else {
            mm = second / 60;
            if (second % 60 != 0) {
                ss = second % 60;
            }
        }
        String ft = "";
        if (hh < 10) {
            ft += "0" + hh + ":";
        } else {
            ft += hh + ":";
        }
        if (mm < 10) {
            ft += "0" + mm + ":";
        } else {
            ft += mm + ":";
        }
        if (ss < 10) {
            ft += "0" + ss;
        } else {
            ft += ss;
        }
        return ft;
    }

    /**
     * 判断输入的一个字符是否为有效的时间-小时
     *
     * @param h
     *            输入参数-小时
     * @return boolean类型参数 <br>
     *         true:表示为有效时间-小时<br>
     *         false:无效时间-小时
     */
    public static boolean isTimeHour(String h) {

        if (Integer.parseInt(h) >= 0 && Integer.parseInt(h) <= 23) {
            return true;
        } else {
            return false;
        }

    }

    /**
     * 判断输入的一个字符是否未有效时间-分钟
     *
     * @param m
     *            输入参数-分钟
     * @return boolean类型参数<br>
     *         true:表示有效时间-分钟<br>
     *         false:表示无效时间-分钟
     */
    public static boolean isTimeMinute(String m) {

        if (Integer.parseInt(m) >= 0 && Integer.parseInt(m) <= 59) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 判断输入的一个字符是否未有效时间-秒
     *
     * @param s
     *            输入参数-秒
     * @return boolean类型参数<br>
     *         true:表示有效时间-秒<br>
     *         false:表示无效时间-秒
     */
    public static boolean isTimeSecond(String s) {

        if (Integer.parseInt(s) >= 0 && Integer.parseInt(s) <= 59) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 1970 年 1 月 1 日开始计算到 Date 当前对象中的时间之间的毫秒
     *
     * @return
     */
    public static long getMillisecondNow() {
        Date d = new Date();
        long s = d.getTime();
        d = null;
        return s;
    }

    /**
     * 根据输入生日获取年龄
     *
     * @param bothday
     *            生日
     * @param format
     *            时间格式
     * @return 年龄
     * @throws ParseException
     *             转换异常
     */
    public static long getAge(String bothday, String format)
            throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        // 相差的毫秒数
        long SSS = System.currentTimeMillis() - sdf.parse(bothday).getTime();
        long age = SSS / 1000 / 60 / 60 / 24 / 365;
        return age;
    }

    /**
     * 获取日期开始时间（一般用于时间查询）
     * @param start 日期
     * @return 日期+时间0:00:00
     */
    public static Date getDateStart(Date start){
        if (Objects.isNull(start)){
            return null;
        }
        Calendar calendar=Calendar.getInstance();
        calendar.setTime(start);
        calendar.set(Calendar.HOUR,0);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND,0);
        calendar.set(Calendar.MILLISECOND,0);
        return calendar.getTime();
    }

    /**
     * 获取日期结束时间（一般用于区间查询）
     * @param end 日期
     * @return 日期+时间23:59:59 999
     */
    public static Date getDateEnd(Date end){
        if (Objects.isNull(end)){
            return null;
        }
        Calendar calendar=Calendar.getInstance();
        calendar.setTime(end);
        calendar.set(Calendar.HOUR,23);
        calendar.set(Calendar.MINUTE,59);
        calendar.set(Calendar.SECOND,59);
        calendar.set(Calendar.MILLISECOND,999);
        return calendar.getTime();
    }
}
