package net.ifok.common.base;

import net.ifok.common.string.StringUtils;

/**
 * @Description:  数字工具
 * @Author: xq 
 * @Date: 2021/5/26 10:02
 **/
public class NumberUtils {

    private NumberUtils(){
        //私有构造
    }

    /**
     * 字符串整数转换为Integer类型整数
     * @param s 字符串int数字
     * @return 返回封装类型字符串
     */
    public static Integer parseInteger(String s){
        if (StringUtils.isEmpty(s)){
            return null;
        }
        return Integer.valueOf(s);
    }

    /**
     * 字符串long转换为封装类型Long
     * @param s 字符串lang
     * @return 返回封装类型Long
     */
    public static Long parseLong(String s){
        if (StringUtils.isEmpty(s)){
            return null;
        }
        return Long.valueOf(s);
    }

    /**
     * 字符串short转换为封装类型short
     * @param s 字符串short
     * @return 返回封装short
     */
    public static Short parseShort(String s){
        if (StringUtils.isEmpty(s)){
            return null;
        }
        return Short.valueOf(s);
    }

    /**
     * 字符串byte类型转换为封装byte类型
     * @param s 字符串byte
     * @return 返回封装byte
     */
    public static Byte parseByte(String s){
        if (StringUtils.isEmpty(s)){
            return null;
        }
        return Byte.valueOf(s);
    }

    /**
     * 字符串float转换为封装类型float
     * @param s 字符串float
     * @return 返回封装类型float
     */
    public static Float parseFloat(String s){
        if (StringUtils.isEmpty(s)){
            return null;
        }
        return Float.valueOf(s);
    }

    /**
     * 字符串double转换为封装类型double
     * @param s 字符串double
     * @return 返回封装类型double
     */
    public static Double parseDouble(String s){
        if (StringUtils.isEmpty(s)){
            return null;
        }
        return Double.valueOf(s);
    }
}
