package net.ifok.common.base;

import java.util.ArrayList;
import java.util.List;

/**
 * 数组工具
 */
public class ListUtils {
    /**
     * 按大小分组
     * @param list 集合
     * @param pageSize 分组大小
     * @return
     */
    public static <T> List<List<T>>  averageList(List<T> list,int pageSize){
        List<List<T>> all=new ArrayList<>();
        int totalSize=list.size();
        if(totalSize<pageSize||pageSize==0){
            all.add(list);
            return all;
        }
        int m=totalSize%pageSize;
        int totalPage=totalSize/pageSize;
        if(m>0){
            totalPage+=1;
        }
        for(int i=1;i<=totalPage;i++){
            if(m==0){
                List ls=list.subList((i-1)*pageSize, i*pageSize);
                all.add(ls);
            }else{
                if(i==totalPage){
                    List ls=list.subList((i-1)*pageSize, totalSize);
                    all.add(ls);
                }else{
                    List ls=list.subList((i-1)*pageSize, i*pageSize);
                    all.add(ls);
                }
            }
        }
        return all;
    }
}
